% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capabilities.R
\name{capabilities}
\alias{capabilities}
\alias{getTargomoCapabilities}
\alias{print.tgm_capabilities}
\title{Get Account Capabilities}
\usage{
getTargomoCapabilities(api_key = Sys.getenv("TARGOMO_API_KEY"),
  region = Sys.getenv("TARGOMO_REGION"), config = list(),
  verbose = FALSE, progress = FALSE)

\method{print}{tgm_capabilities}(x, ...)
}
\arguments{
\item{api_key}{Your Targomo API key - defaults to the \code{TARGOMO_API_KEY}
ennvironment variable}

\item{region}{Your Targomo region - defaults to the \code{TARGOMO_REGION}
environment variable}

\item{config}{Config options to pass to \code{httr::GET} e.g. proxy settings}

\item{verbose}{Whether to print out information about the API call.}

\item{progress}{Whether to show a progress bar of the API call.}

\item{x}{A list, output of \code{\link{getTargomoCapabilities}}}

\item{...}{Further arguments to \code{\link[base]{print}}}
}
\value{
A list of the capabilities of the given API key, in the given region
}
\description{
Function to return a list of the capabilities of the API Key. Comes with a print method
to print out the main results nicely in the console.
}
\examples{
\donttest{
caps <- getTargomoCapabilities()

# print default
print.default(caps)

# print using bespoke method
print(caps)
}

}
