% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basemaps.R
\name{tiles}
\alias{tiles}
\alias{addTargomoTiles}
\alias{targomoMapStyles}
\title{Add Targomo Basemaps to a Leaflet Map}
\usage{
addTargomoTiles(map, style = "basic",
  api_key = Sys.getenv("TARGOMO_API_KEY"), layerId = NULL,
  group = NULL, ...)

targomoMapStyles()
}
\arguments{
\item{map}{A leaflet map}

\item{style}{A valid Targomo Map Style - see \code{targomoMapStyles()}}

\item{api_key}{Your Targomo API key - defaults to the \code{TARGOMO_API_KEY}
ennvironment variable}

\item{layerId}{The layer id to pass to \code{leaflet::addTiles}}

\item{group}{The layer group to pass to \code{leaflet::addTiles}}

\item{...}{Further options to pass to \code{leaflet::addTiles} e.g. options}
}
\value{
The leaflet map with the requested map tiles
}
\description{
This function wraps round \code{leaflet::addTiles} to provide access to the Targomo basemaps.
}
\examples{
\donttest{
# load leaflet package
library(leaflet)

# add basic style to map
leaflet() \%>\% addTargomoTiles(style = "basic")

# add dark blue style to map (without labels)
leaflet() \%>\% addTargomoTiles(style = "darkblue-nolabels")
}
# list Targomo Map Styles
targomoMapStyles()

}
