% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{pHoeffInd}
\alias{pHoeffInd}
\alias{rHoeffInd}
\alias{dHoeffInd}
\alias{qHoeffInd}
\title{Null asymptotic distribution of t* in the continuous case}
\usage{
pHoeffInd(x, lower.tail = T, error = 10^-5)

rHoeffInd(n)

dHoeffInd(x, error = 1/2 * 10^-3)

qHoeffInd(p, error = 10^-4)
}
\arguments{
\item{x}{the value (or vector of values) at which to evaluate the function.}

\item{lower.tail}{a logical value, if TRUE (default), probabilities are
\eqn{P(X\leq x)} otherwise \eqn{P(X>x)}.}

\item{error}{a tolerated error in the result. This should be considered as a
guide rather than an exact upper bound to the amount of error.}

\item{n}{the number of observations to return.}

\item{p}{the probability (or vector of probabilities) for which to get the
quantile.}
}
\value{
dHoeffInd gives the density, pHoeffInd gives the distribution
        function, qHoeffInd gives the quantile function, and rHoeffInd
        generates random samples.
}
\description{
Density, distribution function, quantile function and random generation for
the asymptotic null distribution of t* in the continuous case. That is, in
the case that t* is generated from a sample of jointly continuous independent
random variables.
}
