% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tca.R
\name{tca}
\alias{tca}
\title{Taxicab Correspondance analysis}
\usage{
tca(Y, nAxes = 2, dataName = NULL, combineCollinearRows = c(F, T),
  combineCollinearCols = c(F, T), algorithm = c("exhaustive", "criss-cross",
  "genetic"), returnInputMatrix = c(T, F), verbose = (nAxes > 2),
  exhaustiveAlgorithmMaxnCol = 20, L1MaxDeltaMax = 10^-10)
}
\arguments{
\item{Y}{A m x n matrix of non-negative numbers.  If Y is not a matrix, the 'as.matrix' transformation will be attempted.  Missing values are not allowed.}

\item{nAxes}{Number of axes to compute}

\item{dataName}{A name to be used to identify the outputs in 'plot' and 'saveTCA' ()}

\item{combineCollinearRows}{Should collinear rows be combined?}

\item{combineCollinearCols}{Should collinear columns be combined?}

\item{algorithm}{Algorthim requested - may be abreviated to first two letters}

\item{returnInputMatrix}{Will the input matrix be returned}

\item{verbose}{Report progress (default) or not}

\item{exhaustiveAlgorithmMaxnCol}{Maximum size for exhaustive search}

\item{L1MaxDeltaMax}{Change of L1 norm acceptable for convergence in iterative searches}
}
\value{
A list with class 'tca' containing the following components:
\item{dispersion}{A nAxes-length vector of  matrix of column contributions}
\item{rowScores}{A m x nAxes matrix of column contributions}
\item{colScores}{A nAxes x n matrix of row contributions}
\item{rowMass}{Row weights: apply(Y,1,sum)/sum(Y)}
\item{colMass}{Column weights: apply(Y,2,sum)/sum(Y)}
\item{dataName}{A name to be used to identify the output in 'plot' and 'save'}
\item{algorithm}{Algorithm used (may be different from the algorythm requested)}
\item{dataMatrixTotal}{Sum of the input matrix entries}
\item{dataMatrix}{The matrix used in the computation}
\item{rowColCombined}{A list describing removed or combined rows and columns, if any}
}
\description{
Computes the Taxicab correspondance analysis of a matrix of non-negative numbers
}
\details{
Computations are carried out on the transposed matrix if nrow(Y) < ncol(Y).  In the following, we assume that nrow(Y) >= ncol(Y)

Row and column names will be created if necessary.

Zeros rows and columns are removed.

If ncol(Y) <= exhaustiveAlgorithmMaxnCol the exhaustive algorithm used unless otherwise specified.

If ncol(Y) > exhaustiveAlgorithmMaxnCol the genetic algorithm used unless otherwise specified.

Algorithm = exhaustive is overridden if ncol(Y) > exhaustiveAlgorithmMaxnCol.

For ncol(Y) <= exhaustiveAlgorithmMaxnCol, the user may want to specify algorithm = genetic is nrow(Y) is very large, since exhaustive computation may be slow.

If ncol(Y) <= exhaustiveAlgorithmMaxnCol the genetic algorithm is used unless otherwise specified.

(ncol(Y) = 20 appears to be the maximum practical on 2017 vintage Intel-based desktops).
}
\examples{
tca(rodent,nAxes=4)
tca(rodent,nAxes=4,combineCollinearRows=c(TRUE,FALSE))
}
