% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TechHistConfInterv.R
\name{TeachHistConfInterv}
\alias{TeachHistConfInterv}
\title{Histogram to Visualize Confidence Intervalls}
\usage{
TeachHistConfInterv(
  SampleMean = 0,
  StandardError = 1,
  DegreeFreedom = NULL,
  Confidence = 0.95,
  TestType = "BothTails",
  IsSdEstimated = FALSE,
  NOfSimData = 10000,
  XAxisMax = 5,
  AxisFontSize = 10,
  LabelSize = 3,
  BinWidth = 0.5,
  PrintDensities = FALSE,
  PrintRelFreq = TRUE,
  PlotNormCurv = TRUE,
  RandVarName = "Means",
  SeedValue = NULL,
  Mean = NULL
)
}
\arguments{
\item{SampleMean}{(default=0) Value for sample mean.}

\item{StandardError}{(default=1) Standard error from sample.}

\item{DegreeFreedom}{(default=NULL) required for t-test (when IsSdEstimated=TRUE)}

\item{Confidence}{(default=0.95) Confidence level.}

\item{TestType}{(default="BothTails") User can also choose TestType="LeftTail" or TestType="RightTail"}

\item{IsSdEstimated}{(default=FALSE) standard deviation or standard error are known. Set to FALSE, if estimated.}

\item{NOfSimData}{(default=10000) Number of simulated data points. Higher NOfSimData results in better precision but possibly not all points are considered.}

\item{XAxisMax}{(default=5) X-axis ranges from negative to positive XAxisMax. If XAxisMax is not high enough, some of the simulated points might not be considered.}

\item{AxisFontSize}{(default=10) Font size for axis labels.}

\item{LabelSize}{(default=3) Size of the labels inside the diagram.}

\item{BinWidth}{(default= 0.5) BinWidth expressed in standard deviations.}

\item{PrintDensities}{(default=FALSE) Set PrintDensities=TRUE to print densities in the histogram.}

\item{PrintRelFreq}{(default=TRUE) Set PrintRelFreq=FALSE to suppress the printing of relative frequencies in the histogram.}

\item{PlotNormCurv}{(default=TRUE) If TRUE normal curve is plotted}

\item{RandVarName}{(default="Means") Variable name that is plotted in histogram at x-axis.}

\item{SeedValue}{(default=NULL) Can be any integer and makes simulated points reproducible.}

\item{Mean}{(default=NULL) Value for sample mean. Depreciated. Use SampleMean instead.}
}
\value{
Returns a histogram with confidence interval
}
\description{
The TeachHistConfInterv function is a variation of the TeachHistDens function of this package. It generates a histogram with two horizontal axis. One axis displays z-values the other one the
dimension of the displayed variable and it is optimized to visualize confidence intervals.
}
\details{
The TeachHistConfInterv function supports confidence intervals based on the t-distribution (IsSdEstimated=TRUE) and the z-distribution (IsSdEstimated=FALSE).
}
\examples{
TeachHistConfInterv()
TeachHistConfInterv(SampleMean=2, StandardError=0.2,  IsSdEstimated = FALSE)
TeachHistConfInterv(SampleMean=2, StandardError=0.2, DegreeFreedom = 35,  IsSdEstimated = TRUE)
}
