% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{charGTS}
\alias{charGTS}
\title{Characteristic function of the generalized classical tempered stable (GTS)
distribution.}
\usage{
charGTS(
  t,
  alphap = NULL,
  alpham = NULL,
  deltap = NULL,
  deltam = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL
)
}
\arguments{
\item{t}{A vector of real numbers where the CF is evaluated.}

\item{alphap, alpham}{Stability parameter. A real number between 0 and 2.}

\item{deltap, deltam}{Scale parameter. A real number > 0.}

\item{lambdap, lambdam}{Tempering parameter. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}
}
\value{
The CF of the the generalized classical tempered stable distribution.
}
\description{
Theoretical characteristic function (CF) of the generalized classical
tempered stable distribution. See Rachev et al. (2011) for details. The GTS
is a more generalized version of the CTS \link{charCTS}, as
alpha = alphap = alpham for CTS. The characteristic function is given -
with a small adjustment - by Rachev et al. (2011):
}
\details{
\code{theta} denotes the parameter vector \code{(alphap, alpham, deltap,
deltam, lambdap, lambdam, mu)}. Either provide the parameters individually OR
provide \code{theta}. Characteristic function shown here is from Rachev et al.
(2011).
\deqn{\varphi_{GTS}(t;\theta):=
E_{\theta}\left[\mathrm{e}^{\mathrm{i}tX}\right]=
\exp\left(\mathrm{i}t\mu-\mathrm{i}t\Gamma(1-\alpha_+)
\left(\delta_+\lambda_+^{\alpha_+-1}\right)\right.\\}
\deqn{\left. +\mathrm{i}t\Gamma(1-\alpha_-)
\left(\delta_-\lambda_-^{\alpha_--1}\right)\right.\\}
\deqn{\left.+\delta_+\Gamma(-\alpha_+)
\left(\left(\lambda_+-\mathrm{i}t\right)^{\alpha_+}
-\lambda_+^{\alpha_+}\right) \right.\\}
\deqn{\left.+\delta_-\Gamma(-\alpha_-)
\left(\left(\lambda_-+\mathrm{i}t\right)^{\alpha_-}
-\lambda_-^{\alpha_-}\right)\right)}
}
\examples{
x <- seq(-5,5,0.25)
y <- charGTS(x,0.3,0.2,1,1,1,1,0)

}
\references{
Rachev, S. T.; Kim, Y. S.; Bianchi, M. L. & Fabozzi, F. J. (2011),
'Financial models with Lévy processes and volatility clustering'
\doi{10.1002/9781118268070}
}
