% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{rMTS}
\alias{rMTS}
\title{Function to generate random variates of MTS distribution}
\usage{
rMTS(
  n,
  alpha = NULL,
  delta = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL,
  methodR = "SR",
  k = 10000
)
}
\arguments{
\item{n}{sample size (integer).}

\item{alpha}{Stability parameter. A real number between 0 and 2.}

\item{delta}{Scale parameter. A real number > 0.}

\item{lambdap, lambdam}{Tempering parameter. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{methodR}{A String. Either "TM", "AR" or "SR".}

\item{k}{integer: the level of truncation, if \code{methodR == "SR"}.
10000 by default.}
}
\value{
Generates \code{n} random numbers of the CTS distribution.
}
\description{
Generates \code{n} random numbers distributed according to the modified
tempered stable (MTS) distribution.
}
\details{
Currently, random variants can only be generated using the series
representation given by Bianchi et al. (2011).

It is recommended to check the generated random numbers once for each
distribution using the density function. If the random numbers are shifted,
e.g. for the method "SR", it may be worthwhile to increase k.
}
\examples{
rMTS(2,0.5,1,1,1,0,NULL,"SR")

}
\references{
Bianchi, M. L.; Rachev, S. T.; Kim, Y. S. & Fabozzi, F. J. (2011), 'Tempered
infinitely divisible distributions and processes'
\doi{10.1137/S0040585X97984632}
}
