% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lldr.R
\name{lldr.inner}
\alias{lldr.inner}
\title{lldr.inner}
\usage{
lldr.inner(xmain, y, Y, XMain, XOther = NULL, h = NULL, method = "level")
}
\arguments{
\item{xmain}{a particular value for the "main" continuous x variable}

\item{y}{a particular value of y to compute local linear distribution
regression for}

\item{Y}{a vector containing the data for the outcome}

\item{XMain}{a vector containing the data for the "main" x variable}

\item{XOther}{a matrix or data.frame containing the data for the "other"
x variables}

\item{h}{optional bandwidth}

\item{method}{"level" or "rank" determining whether method should
be used conditional on ytmin1 or the rank of ytmin1}
}
\value{
an llDR object
}
\description{
This calculates a single distribution regression for one value
 of y and one value of xmain
}
\examples{
data(igm)
lcinc <- 10
Y <- igm$lcfincome
XMain <- igm$lfincome
XOther <- data.frame(COL=1*(igm$HEDUC=="COL"))
lldr.inner(lcinc, 10, Y, XMain, XOther)

}
