% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCSUS.R
\name{MC_SubSam}
\alias{MC_SubSam}
\title{MonteCarlo with Subset-Sampling}
\usage{
MC_SubSam(
  lsf,
  lDistr,
  Nsubset = 1e+05,
  p0 = 0.1,
  MaxSubsets = 10,
  Alpha = 0.05,
  variance = "uniform",
  debug.level = 0
)
}
\arguments{
\item{lsf}{limit-state function}

\item{lDistr}{list of basevariables in input space}

\item{Nsubset}{number of samples in each simulation level}

\item{p0}{level probability or conditional probability}

\item{MaxSubsets}{maximum number of simulation levels that are used to terminate the simulation procedure to avoid infinite loop when the target domain cannot be reached}

\item{Alpha}{confidence level}

\item{variance}{gaussian, uniform}

\item{debug.level}{If 0 no additional info if 2 high output during calculation}
}
\value{
The results are provided within a list() of the following elements:

beta

pf

betaCI and pfCI are the corresponding confidence intervals

CoV COV of the result

NumOfSubsets Amount of Markov-Chains

NumOfEvalLSF_nom Markov-Chains times Iterations

NumOfEvalLSF_eff Internal counter that shows the real evaluations of the lsf

runtime Duration since start to finish of the function
}
\description{
MonteCarlo with Subset-Sampling
}
\references{
AU, S. K. & BECK, J. L. Estimation of small failure probabilities in high dimensions by subset simulation. Probabilistic Engineering Mechanics, 2001, 16.4: 263-277.
}
\author{
(C) 2021 - K. Nille-Hauf, T. Feiri, M. Ricker - Hochschule Biberach, Institut fuer Konstruktiven Ingenieurbau
}
