% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FwerMethodsSD.R
\name{BonferroniCor_SD}
\alias{BonferroniCor_SD}
\title{Bonferroni multiple testing method for correlations 
with stepdown procedure.}
\usage{
BonferroniCor_SD(data, alpha, stat_test = "empirical", vect = FALSE)
}
\arguments{
\item{data}{matrix of observations}

\item{alpha}{level of multiple testing}

\item{stat_test}{\describe{
  \item{'empirical'}{\eqn{\sqrt{n}*abs(corr)}}
  \item{'fisher'}{   \eqn{\sqrt{n-3}*1/2*\log( (1+corr)/(1-corr) )}}
  \item{'student'}{  \eqn{\sqrt{n-2}*abs(corr)/\sqrt(1-corr^2)}}
  \item{'gaussian'}{ \eqn{\sqrt{n}*mean(Y)/sd(Y)} with \eqn{Y=(X_i-mean(X_i))(X_j-mean(X_j))}}
}}

\item{vect}{if TRUE returns a vector of TRUE/FALSE values, corresponding to \code{vectorize(cor(data))};
if FALSE, returns an array containing rows and columns of significative correlations}
}
\value{
Returns \itemize{\item{a vector of logicals, equal to TRUE if the corresponding element of the statistic vector is rejected, if \code{vect=TRUE},} \item{a vector containing indexes \eqn{\lbrace(i,j),\,i<j\rbrace} for which correlation between variables \eqn{i} and \eqn{j} is significative, if \code{vect=FALSE}.}}
}
\description{
Bonferroni multiple testing method for correlations 
with stepdown procedure.
}
\examples{
 
n <- 100
p <- 10
corr_theo <- diag(1,p)
data <- MASS::mvrnorm(n,rep(0,p),corr_theo)
alpha <- 0.05
res <- BonferroniCor_SD(data,alpha,stat_test='empirical')
}
\references{
Bonferroni, C. E. (1935). Il calcolo delle assicurazioni su gruppi di teste. Studi in onore del professore salvatore ortu carboni, 13-60.

Roux, M. (2018). Graph inference by multiple testing with application to Neuroimaging, Ph.D., Université Grenoble Alpes, France, https://tel.archives-ouvertes.fr/tel-01971574v1.
}
\seealso{
ApplyFwerCor, BonferroniCor
}
