# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Returns a vector containing the upper triangle of a matrix, without the diagonal.
#'
#' @param mat a square matrix
#' @return Returns a vector containing the upper triangle of a matrix, without the diagonal.
#' @seealso unvectorize
#' @export
#'
#' @examples
#' vectorize(matrix(1:9,3,3))
vectorize <- function(mat) {
    .Call('_TestCor_vectorize', PACKAGE = 'TestCor', mat)
}

#' Returns an upper-triangle matrix, without the diagonal, containing the elements of a given vector.
#'
#' @param vect A vector containing the upper triangle of a matrix, without the diagonal
#' @return Returns an upper-triangle matrix where each entry is given by the vector containing the upper triangle of a matrix, without the diagonal.
#' @seealso vectorize
#' @export
#'
#' @examples
#' unvectorize(1:10)
unvectorize <- function(vect) {
    .Call('_TestCor_unvectorize', PACKAGE = 'TestCor', vect)
}

#' Returns the theoretical covariance of empirical correlations.
#'
#' @param r a correlation matrix
#' @return Returns the theoretical covariance of empirical correlations.
#' @export
#' @references Aitkin, M. A. (1969). Some tests for correlation matrices. Biometrika, 443-446.
#' @seealso covDcorNorm
#'
#' @examples
#' p <- 10
#' corr_theo <- diag(1,p)
#' corr_theo[2:p,] <- 0.3
#' corr_theo[,2:p] <- 0.3
#' covDcor(corr_theo)
covDcor <- function(r) {
    .Call('_TestCor_covDcor', PACKAGE = 'TestCor', r)
}

#' Returns the theoretical covariance of empirical correlations.
#'
#' @param r a correlation matrix
#' @return Returns the theoretical covariance of 2nd order statistics, 
#'         \eqn{\sqrt{n}*mean(Y)/sd(Y)} with \eqn{Y=(X_i-mean(X_i))(X_j-mean(X_j))}.
#' @export
#' @seealso covDcor
#'
#' @examples
#' p <- 10
#' corr_theo <- diag(1,p)
#' corr_theo[2:p,] <- 0.3
#' corr_theo[,2:p] <- 0.3
#' covD2nd(corr_theo)
covD2nd <- function(r) {
    .Call('_TestCor_covD2nd', PACKAGE = 'TestCor', r)
}

