% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_stat.R
\name{eval_stat}
\alias{eval_stat}
\title{Evaluates the test statistics for tests on correlation matrix entries.}
\usage{
eval_stat(data, type = "empirical")
}
\arguments{
\item{data}{matrix of observations}

\item{type}{\describe{
  \item{'empirical'}{\eqn{\sqrt{n}*abs(corr)}}
  \item{'fisher'}{\eqn{\sqrt{n-3}*1/2*\log( (1+corr)/(1-corr) )}}
  \item{'student'}{\eqn{\sqrt{n-2}*abs(corr)/\sqrt(1-corr^2)}}
  \item{'2nd.order'}{\eqn{\sqrt{n}*mean(Y)/sd(Y)} with \eqn{Y=(X_i-mean(X_i))(X_j-mean(X_j))}}
}}
}
\value{
Returns the test statistics for correlation testing.
}
\description{
Evaluates the test statistics for tests on correlation matrix entries.
}
\examples{
n <- 100
p <- 10
corr_theo <- diag(1,p)
data <- MASS::mvrnorm(n,rep(0,p),corr_theo)
stat <- eval_stat(data,'fisher')
}
