% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_functions.R
\name{plotExposureRateFinal}
\alias{plotExposureRateFinal}
\title{Draw exposure rate plots by final theta segment}
\usage{
plotExposureRateFinal(
  object,
  config = NULL,
  max_rate = 0.25,
  theta = "Estimated",
  segment_cut = NULL,
  color = "red",
  file_pdf = NULL,
  width = 7,
  height = 6,
  mfrow = c(2, 4),
  burn = 0,
  retain = NULL
)
}
\arguments{
\item{object}{An output object generated by \code{\link{Shadow}}.}

\item{config}{A \code{\linkS4class{config_Shadow}} object.}

\item{max_rate}{A target item exposure rate.}

\item{theta}{By which theta to base the segments, either "Estimated" or "True".}

\item{segment_cut}{A vector of cut values defining theta segments.}

\item{color}{A vector of colors.}

\item{file_pdf}{If supplied a filename, save as a PDF file.}

\item{width}{Width of the graphics object.}

\item{height}{Height of the graphics object.}

\item{mfrow}{Number of multiple figures defined as c(nrow, ncol).}

\item{burn}{An integer identifying the first x simulees to discard as burn-in.}

\item{retain}{An optional vector of indices identifying the simulees to retain.}
}
\description{
Draw exposure rate plots by final theta segment.
}
\examples{
\donttest{
true_theta <- runif(10, min = -3.5, max = 3.5)
resp_science <- makeTest(itempool_science, info_type = "FISHER", true_theta = true_theta)@data
constraints_science2 <- updateConstraints(constraints_science, off = c(14:20, 32:36))
config_science <- createShadowTestConfig(
  MIP = list(solver = "LPSOLVE"),
  exposure_control = list(method = "ELIGIBILITY")
)
solution <- Shadow(config_science, constraints_science2, true_theta, data = resp_science)
p <- plotExposureRateFinal(solution, config_science, 0.25)
}
}
