% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_loglikelihood_functions.r
\docType{methods}
\name{calcLogLikelihood}
\alias{calcLogLikelihood}
\alias{calcLogLikelihood,item_pool,numeric,numeric-method}
\alias{calcLogLikelihood,item_pool,numeric,matrix-method}
\alias{calcLogLikelihood,item_pool,matrix,numeric-method}
\alias{calcLogLikelihood,item_pool,matrix,matrix-method}
\title{Calculate log-likelihood}
\usage{
calcLogLikelihood(object, theta, resp)

\S4method{calcLogLikelihood}{item_pool,numeric,numeric}(object, theta, resp)

\S4method{calcLogLikelihood}{item_pool,numeric,matrix}(object, theta, resp)

\S4method{calcLogLikelihood}{item_pool,matrix,numeric}(object, theta, resp)

\S4method{calcLogLikelihood}{item_pool,matrix,matrix}(object, theta, resp)
}
\arguments{
\item{object}{an \code{\linkS4class{item_pool}} object.}

\item{theta}{theta values to use.}

\item{resp}{the response data to use.}
}
\value{
\code{\link{calcLogLikelihood}} returns values of log-likelihoods.
}
\description{
\code{\link{calcLogLikelihood}} is a function to calculate log-likelihood values.
}
\examples{
j_pool   <- calcLogLikelihood(itempool_science, seq(-3, 3, 1), 0)

}
\references{
Rasch, G. (1960). \emph{Probabilistic models for some intelligence and attainment tests.}
Copenhagen: Danish Institute for Educational Research.

Lord, F. M. (1952). A theory of test scores (Psychometric Monograph No. 7). Richmond, VA: Psychometric Corporation.

Birnbaum, A. (1957). \emph{Efficient design and use of tests of mental ability for various decision-making problems}
(Series Report No. 58-16. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{On the estimation of mental ability}
(Series Report No. 15. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{Further considerations of efficiency in tests of a mental ability}
(Series Report No. 17. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1968). Some latent trait models and their use in inferring an examinee's ability.
In Lord, F. M., Novick, M. R. (eds.), \emph{Statistical Theories of Mental Test Scores}, 397-479.
Reading, MA: Addison-Wesley.

Masters, G. N. (1982). A Rasch model for partial credit scoring.
\emph{Psychometrika, 47}(2), 149-174.

Andrich, D. (1978). A rating formulation for ordered response categories.
\emph{Psychometrika, 43}(4), 561-573.

Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm.
\emph{Applied Psychological Measurement, 16}(2), 159-176.

Samejima, F. (1969). Estimation of latent ability using a response pattern of graded scores.
\emph{Psychometrika Monograph, 17}.
}
