% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AccuModel.R
\name{AccuModel}
\alias{AccuModel}
\title{Evaluation Of Sex-prediction Accuracy}
\usage{
AccuModel(f, x, y, byPop = TRUE, method = "lda", cutoff = 0.5,
  ref. = "F", post. = "M", ...)
}
\arguments{
\item{f}{Formula in the form \code{groups ~ x1 + x2 + ...}. The grouping
factor is placed to the left hand side while the numerical measurements are
placed to the right hand side}

\item{x}{Data frame to be fitted to the model}

\item{y}{New data frame to be tested}

\item{byPop}{Logical;if \code{TRUE} returns the accuracy in different
populations, Default: \code{TRUE}.}

\item{method}{Different methods of modeling see \code{details} ,
Default:'lda'}

\item{cutoff}{cutoff value when using logistic regression, Default: 0.5}

\item{ref.}{reference category in the grouping factor, Default: 'F'}

\item{post.}{positive category in the grouping factor, Default: 'M'}

\item{...}{additional arguments that can passed to modeling and
\link[caret]{confusionMatrix} function.}
}
\value{
Accuracy parameters for the tested model
}
\description{
Testing the accuracy of different sex prediction models
  using the \link[caret]{confusionMatrix} function
}
\details{
Data frames to be entered as input need to be arranged in a similar
  manner to \code{\link{Howells}} dataset. Methods used for modeling are:
  \describe{ \item{\code{lda}}{linear discriminant analysis}
  \item{\code{qda}}{quadratic discriminant analysis}
  \item{\code{mda}}{mixture discriminant analysis} \item{\code{fda}}{flexible
  discriminant analysis} \item{\code{rda}}{regularized discriminant analysis}
  \item{\code{glm}}{binomial logistic regression} }
}
\examples{
library(TestDimorph)
AccuModel(Sex~GOL+NOL+BNL,x = Howells,y = Howells,byPop = FALSE,method = "lda")
}
