\docType{package}
\name{TestGardener}
\alias{TestGardener}
\title{Analyses of Test and Rating Scale using Information Theor7}
\description{
TestGardener is designed to permit the analysis of choice data from multiple choice tests and rating scales using information as an alternative to the usual models based on probability of choice. Probabability and information are related by the simple transformation "information = -log probability".  Another term for information is "surprisal."

The advantage of information methodology, often used in the engineering and physical sciences, is that information is on what is called a "ratio scale".  That is, information has a lower limit of zero, is unbounded above, and can be added, subtracted and rescaled with a positive multiplier.  That is, information has the same magnitude structure as the classic scientific measures.

The disadvantage of probability as a basis for representing choice is that differences near its two boundaries are on very different scales than those near 0.5, and our visual and other sensory systems, which are adapted to mangitudes, have many problems in assessing the nonlinear probability continuum.

TestGardener also uses highly adaptable and computationally efficient spline basis functions to represent item characteristic curves with as much flexibility as the task requires.  The higher variability revealed by information or surprisal curves reveals many more insights into choice behavior than the usual simple curve employed in standard probability-based item response theory.
}