% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreambleAdjustment.R
\name{ReplaceFromTable}
\alias{ReplaceFromTable}
\title{ReplaceFromTable}
\usage{
ReplaceFromTable(x, table, tableRow, columnNames, commandNames)
}
\arguments{
\item{x}{A character vector, each element is suppose to represent a line}

\item{table}{Data frame from which to extract the information}

\item{tableRow}{Integer, row of the \code{table} to be used}

\item{columnNames}{Character vector with the names of the columns to be used}

\item{commandNames}{Character vector with the same length as \code{columnNames}. Contains the names of the 'LaTeX' commands to be replaced.}
}
\value{
A character vector, representing the text \code{x}, where all instances of
\code{ \\newcommand\\commandNames[i]\{<random text>\}} have been replaced with
\code{ \\newcommand\\commandNames[i]\{table[tableRow, columnName[i]\}}.
}
\description{
Given a 'LaTeX' file represented as a character vecotr with \code{x}, it replaces from a table the commands given by \code{commandNames}. for the values found on the table.


\code{\\newcommand\{\\commandName[i]\}\{table[tableRow, columnName[i]]\}}.
}
\details{
To do the replacement for each item, it uses the function \code{\link{ReplacePreambleCommand}}. See the details in that function for more information.
}
\examples{

custom_preambles <- list()
for (i in 1:nrow(TexExamRandomizer::testclass)) {
    custom_preambles <-
        c(
            custom_preambles,
            list(
                TexExamRandomizer::ReplaceFromTable(
                    TexExamRandomizer::testdoc$preamble,
                    table = TexExamRandomizer::testclass,
                    tableRow = i,
                    columnNames = c("Class", "Roll.Number", "Nickname"),
                    commandNames = c("class", "rollnumber", "nickname")
                )
            )

        )

}
}
\seealso{
Other Preamble adjustment: \code{\link{ReplacePreambleCommand}}
}
