% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wrappers.R
\name{CreateRandomExams}
\alias{CreateRandomExams}
\title{CreateRandomExams}
\usage{
CreateRandomExams(x, layersNames = c("questions", "choices"),
  layersCmd = c("question", "(choice|CorrectChoice)"), outputBaseName,
  outputDirectory, cmdReorder = rep_len(TRUE, length(layersNames)),
  sectionReorder = FALSE, infoTable = NULL, colNames = NULL,
  cmdNames = NULL, nOutputVersions = nrow(infoTable),
  nOutputQuestions = "max", answerSheetCorrectTag = NULL,
  answerSheetWrongTag = NULL, optionList = NULL)
}
\arguments{
\item{x}{A character vector, each element represents one line of the latex document}

\item{layersNames}{A character vector, with each element representating the environment name to be searched as \code{cmdName} as describe in \code{\link{FindBegin}} and \code{\link{FindEnd}}}

\item{layersCmd}{A character vector, with the same length as \code{layersNames}. with each element representing the environment command to be serached as \code{cmdName} as described in \code{\link{FindCommand}}.}

\item{outputBaseName}{String, The basename for the output files.}

\item{outputDirectory}{String, The output directory.}

\item{cmdReorder, sectionReorder}{Logical vector, the length of \code{cmdReorder} determines how many layers deep are we going to dig and randomize. For that reason, if \code{sectionReorder} is just a scalar, it will assume that it repeats for every \code{cmdReorder} that is given. See \code{\link{RandomizeDocument}} for extra details on these parameters.}

\item{infoTable}{Table with information, if NULL, no information is added to the exams}

\item{colNames}{Character vector, Column names from the \code{infoTable} from which we will extract the information.

       It first tries to find the column names literally, if ti couldn't find them like that, it will try to use them as a regular expression to find a column that matches the column.}

\item{cmdNames}{Character vector, Names of the commands on the tex file, \code{\\<cmdNames[i]>}, that are to be matched with the columns to replace the information from the table in those commands. For extra info see also \code{\link{ReplaceFromTable}}}

\item{nOutputVersions}{Number of different random versions of the exam to be outputted}

\item{nOutputQuestions}{Number of "questions" on the output exams. If the input is a scalar, the program will decide how to more evenly split the questions between all the sections, otherwise one can directly provide an integer vector specifying how many questions from each section are needed. (this only searches the "items" of the outermost layer)}

\item{answerSheetCorrectTag, answerSheetWrongTag}{If the tags are not given, the output answersheet will be \code{NULL}. In other cases, these tags can be regular expressions}

\item{optionList}{Instead of writing the options on the function. Options could be given to optionList, and it will add those options. As long as the names are correct}
}
\value{
A list that contains
\describe{
    \item{\code{outputDirectory}}{The output directory}
    \item{\code{outputFiles}}{A character vector that contains all the output names}
    \item{\code{FullAnswerSheet}}{The full answer sheet of all the exams.

    Each answer sheet is created as described by \code{\link{ConstructAnswerSheet}}, and all the answer sheets are joined together with a version number in front as an added column to bind them all together. The original version has the number 0, all the output versions have sequential numbers as Version

    This wrapper function assumes equal depth on all branches of the tree structure, so that the number of columns is always identical in the answer sheet
    }
}
}
\description{
This function creates a series of randomized exams from a tex document and personalizes the information from a table (if a table is given) and a series of command names where thae information shoudl be replaced.
}
\details{
All the output exams are named with \code{outputBaseName} followed by 00i identifying the number of the exam (The number of zeros is the minimum that allows for all the exams to have a different number) and \code{"_Version_"} followed by the version number of the exam and "\code{.tex}". That is:

\code{<outputDirectory>/<outputBaseName>00i_Version_j.tex}

The number of exams outputted will always be the same as the number of versions if no table is given. However, if a table is added as input. It will create one exam for each row of the table, and it will try to divide as evenly as possible how to give the versions between the different rows. (Having one exam for each row, which will probably represent a student)
}
\seealso{
\code{\link{ConstructAnswerSheet}}, \code{\link{ReplaceFromTable}}, \code{\link{RandomizeDocument}} for extra details. . To see examples of how to use it, look at the code in \code{\link{jsonhwparser}}
}
