% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnswerSheets.R
\name{GenerateShortAnswerSheet}
\alias{GenerateShortAnswerSheet}
\title{Generating a short answer sheet}
\usage{
GenerateShortAnswerSheet(ExamSheet, versionColName = "Version",
  correctColName = "CorrectChoice")
}
\arguments{
\item{ExamSheet}{a exam sheet that contains all versions, similar to \code{\link{CreateRandomExams}}}

\item{versionColName}{The name of the column in the original exam that contains the version number}

\item{correctColName}{The name of the column that contains the last index for the correct tag, or NA if it is not a correct choice.}
}
\value{
A data frame \itemize{
 \item Each row identifies one version of the answer sheet
 \item the first column is the version number, the rest of the columns are the questions,
 }
}
\description{
Given a number of answer sheets generated by \code{\link{ConstructAnswerSheet}} that have been binded together. And that have a column, \code{versionColName}, that identifies each version. It collects all the answers together and places all the answers together for each exam.
}
\details{
Note that if the version number is 0, it is ignored, since it understands that version 0 is the reference version.

If the document has more than two layers, keep in mind that it just shows the top most layer numbering and then the inner most number of the correct answers.

Note how this implies as well that an exam with more than one possible answer can not be simplified into a short answer sheet.


IMPORTANTLY, If a certain exam has less answers than other exams, the are just cited sequentially. Which may cause confusion. To clarify. This may happen if a certain question has more than one solution marked as "correct", or if a certain question has no solutions marked as correct. In that case, The short answer sheet just sequentially names all the correct answers, disregarding which questions they are referring to. (This is a very special case that will only come up in a real scenario if you are writing a short answer question in the middle of a multiple choice test. Or if you are writing some questions to have multiple correct answers, but only a few of them, and those questions are not included in all exams... (So evil))
}
\examples{

csvfile <- system.file(
    "extdata",
    "ExampleTables",
    "ExampleAnswerSheet.csv",
    package = "TexExamRandomizer"
)
testASheet <- read.csv(
    csvfile,
    header = TRUE,
    stringsAsFactors = FALSE,
    na.strings = c("", "NA", "Na"),
    strip.white = TRUE
)

GenerateShortAnswerSheet(testASheet)
}
\seealso{
Other Extracting information: \code{\link{ConstructAnswerSheet}},
  \code{\link{CountNumberOfSections}},
  \code{\link{FindExamAnswers}}
}
