% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_terms.R
\name{top_terms}
\alias{top_terms}
\title{Top Terms Function}
\usage{
top_terms(x, w, y, alpha, lambda, k, wordcloud, max.words, scale, rot.per,
  family)
}
\arguments{
\item{x}{the input matrix of terms to be selected.}

\item{w}{optional argument. the input matrix of structured data to not be selected.}

\item{y}{the response variable}

\item{alpha}{the glmnet alpha}

\item{lambda}{the glmnet lambda}

\item{k}{the k top terms}

\item{wordcloud}{set TRUE to plot the wordcloud}

\item{max.words}{the maximum number of words in the wordcloud}

\item{scale}{the wordcloud size.}

\item{rot.per}{wordcloud proportion 90 degree terms}

\item{family}{glmnet family}
}
\value{
the top k terms and the corresponding wordcloud.
}
\description{
Top Terms Function
}
\examples{
\donttest{
set.seed(1)
data("stock_data")
data("news_data")
y=as.matrix(stock_data[,2])
w=as.matrix(stock_data[,3])
data("news_data")
X=news_data[,2:ncol(news_data)]
x=as.matrix(X)
grid_alphas=seq(by=0.05,to=0.95,from=0.05)
cont_folds=TRUE
t=length(y)
optimal_alphas=optimal_alphas(x[1:(t-1),],w[1:(t-1),],
y[2:t],grid_alphas,TRUE,"gaussian")
top_trms<- top_terms(x[1:(t-1),],w[1:(t-1),],y[2:t],
optimal_alphas[[1]], optimal_alphas[[2]],10,TRUE,
10,c(2,0.3),.15,"gaussian")
}

}
