% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_two.R
\name{boot_two}
\alias{boot_two}
\title{Bootstrap sampling for difference in means between two groups}
\arguments{
\item{data}{Data frame contain raw data.}

\item{groups_col}{Factor. Column containing names of two populations to compare}

\item{n_max}{Numeric. Maximum sample size to extrapolate simulations.}

\item{n_min}{Numeric. Minimum sample size to extrapolate simulations. Defaults to 3.}

\item{iter}{Numeric. Number of bootstrap samples. Defaults to 29.}

\item{response}{Numeric. Column containing thermal limit data for individual samples.}

\item{group1}{String. Name of first population to compare.}

\item{group2}{String. Name of second population to compare.}

\item{colour_exp}{Colour of the experimental data. Defaults to "blue".}

\item{colour_extrap}{Colour of the extrapolated data. Defaults to "red".}

\item{legend.position}{Position of the legend. Defaults to "top". Can be "bottom", "left", "right", or "none".}

\item{ggtheme}{The theme for the ggplot created. See ggplot2 themes for options. Default set to theme_classic().}
}
\value{
A data frame of bootstrap resamples
}
\description{
Calculate difference in mean CT limits between two groups.
}
\examples{
\donttest{
head(coreid_data)
sims <- boot_two(data = coreid_data,
                        groups_col = col,
                        response = response,
                        group1 = "Catorhintha schaffneri_APM",
                        group2 = "Catorhintha schaffneri_NPM",
                        n_max = 49,
                        iter = 99)
}
}
