% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waldtype_power.R
\name{power_RET}
\alias{power_RET}
\title{Power related calculations for three-arm clinical trials}
\usage{
power_RET(
  experiment,
  reference,
  placebo,
  Delta,
  sig_level = NULL,
  power = NULL,
  n = NULL,
  allocation = c(1/3, 1/3, 1/3),
  distribution = NULL,
  ...
)
}
\arguments{
\item{experiment}{a numeric vector specifying the parameters of the experimental
treatment group in the alternative hypothesis}

\item{reference}{a numeric vector specifying the parameters of the reference
treatment group in the alternative hypothesis}

\item{placebo}{a numeric vector specifying the parameters of the placebo
treatment group in the alternative hypothesis}

\item{Delta}{a numeric value specifying the non-inferiority/superiority margin}

\item{sig_level}{A numeric value specifying the significance level (type I error probability)}

\item{power}{A numeric value specifying the target power (1 - type II error probability)}

\item{n}{The total sample size. Needs to be at least 7.}

\item{allocation}{A (non-empty) vector specifying the sample size allocation (nExp/n, nRef/n, nPla/n)}

\item{distribution}{A character specifying the distribution of the endpoints. Must
must be either of \code{"binary"}, \code{"poisson"}, \code{"negbin"}, \code{"exponential"}, \code{"normal"}}

\item{...}{Further arguments. See details.}
}
\value{
A list with class "power.htest" containing the following components:
\item{n}{The total sample size}
\item{power}{A numeric value specifying the target power}
\item{Delta}{A numeric value specifying the non-inferiority or superiority margin. }
\item{sig.level}{A character string specifying the significance level}
\item{type}{A character string indicating what type of Wald-type test will be performed}
\item{allocation}{A vector with the sample size allocation (nExp/n, nRef/n, nPla/n)}
\item{sig.level}{The significance level (Type I error probability)}
\item{nExp}{A numeric value specifying the number of sample in the experimental treatment group}
\item{nRef}{A numeric value specifying the number of sample in the reference treatment group}
\item{nPla}{A numeric value specifying the number of sample in the placebo treatment group}
}
\description{
Compute power, sample size, or level of significance for
Wald-type test for non-inferiority or superiority of the experimental treatment
versus reference treatment with respect to placebo.
}
\details{
If the individual group sample sizes, i.e. \code{n*allocation}
are not natural number, the parameters \emph{n} and \emph{allocation}
will be re-calculated.

The additional parameter \code{var_estimation} is a character string
specifying how the variance for the Wald-type test statistic is estimated
in the Poisson and negative binomial model. Must be \emph{RML} for restricted
maximum-likelihood, or \emph{ML} for unrestricted maximum-likelihood
}
\examples{
power_RET(experiment = 15, reference = 17, placebo = 20,
         Delta = 0.8, sig_level = 0.025, power = 0.8,
         allocation = c(1, 1, 1) / 3,
         var_estimation = "RML",
         distribution = "poisson")
}
\keyword{power}
\keyword{samplesize}
\keyword{waldtype}
