% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TileDetector.R
\name{TileDetector}
\alias{TileDetector}
\title{Tile Detector}
\usage{
TileDetector(inRasters, reord = FALSE)
}
\arguments{
\item{inRasters}{a list of RasterLayers (see \link[raster]{raster})}

\item{reord}{logical. If set to \code{FALSE}, tiles will be stored in the same order in which
they appear in \code{inRasters}. If \code{TRUE}, tiles will be reordered by column and then by row.}
}
\value{
The output of this function is a list of three \link[sp]{SpatialPolygonsDataFrame} objects:
  \item{tilePolygons}{The tiling grid. Each polygon corresponds to the extent of a single unbuffered tile.}
  \item{buffPolygons}{The buffered tiling grid. Each polygon corresponds to the extent of a buffered tile. These
  polygons overlap with neighbouring tiles. If \code{buffer} is set to 0, this output will be identical to \code{tilePolygons}.}
  \item{nbuffPolygons}{Non-overlapping buffered tiles. These polygons remove overlapping buffers for adjacent tiles, but
  preserve buffers for tiles on the edges of the tiling grid. Useful for "reassembling" data that had been originally broken
  into tiles.}
}
\description{
Function for detecting existing tiling scheme from a list of RasterLayers.
}

