% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.acf.R
\name{ts.acf}
\alias{ts.acf}
\title{Extract the ACF and PACF parameters of time series and their model residuals}
\usage{
ts.acf(tsdata, model_residuals, a=0.95, tojson=F)
}
\arguments{
\item{tsdata}{The input univariate time series data}

\item{model_residuals}{The model's residuals after fitting a model to the time series}

\item{a}{The significant level (default a=0.95)}

\item{tojson}{If TRUE the results are returned in json format, default returns a list}
}
\value{
A list with the parameters:
\itemize{
 \item acf.parameters: 
 \itemize{ \item acf The estimated acf values of the input time series
 \item acf.lag The lags at which the acf is estimated
 \item confidence.interval.up The upper limit of the confidence interval
 \item confidence.interval.low The lower limit of the confidence interval}
 \item pacf.parameters: 
 \itemize{ \item pacf The estimated pacf values of the input time series
 \item pacf.lag The lags at which the pacf is estimated
 \item confidence.interval.up The upper limit of the confidence interval
 \item confidence.interval.low The lower limit of the confidence interval}
 \item acf.residuals.parameters: 
 \itemize{ \item acf.res The estimated acf values of the model residuals
 \item acf.res.lag The lags at which the acf is estimated of the model residuals
 \item confidence.interval.up The upper limit of the confidence interval
 \item confidence.interval.low The lower limit of the confidence interval}
 \item pacf.residuals.parameters: 
 \itemize{ \item pacf.res The estimated pacf values of the model residuals
 \item pacf.res.lag The lags at which the pacf is estimated of the model residuals
 \item confidence.interval.up The upper limit of the confidence interval
 \item confidence.interval.low The lower limit of the confidence interval}}
}
\description{
This function is included in ts.analysis function and aims to extract the ACF and PACF details 
of the input time series data and the ACF, PACF of the residuals after fitting an Arima model.
}
\details{
This function is used internally in ts.analysis function and the output is a list with grouped 
ACF and PACF parameters of the input time series data, as well as the ACF and PACF parameters 
of the residuals needed for the graphical purposes in OBEU.
}
\examples{
ts.acf(Athens_draft_ts)

}
\seealso{
\code{\link{ts.analysis}}, \code{\link[forecast]{Acf}}, \code{\link[forecast]{Pacf}}
}
\author{
Kleanthis Koupidis
}
