% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-merge-data.R
\name{merge_length_fishing_trips_hauls}
\alias{merge_length_fishing_trips_hauls}
\title{Merge fishing trips, length and hauls data}
\usage{
merge_length_fishing_trips_hauls(data_hauls, data_length_fishing_trips)
}
\arguments{
\item{data_hauls}{Data frame processed with \code{process_hauls()}.}

\item{data_length_fishing_trips}{Data frame with length data by fishing trip and haul.}
}
\value{
Data frame with consolidated data from fishing trips, length and hauls.
}
\description{
Joins data from fishing trips, length and hauls, combining catches by species,
length ranges (minimum and maximum) and spatial-temporal information of each haul.
}
\examples{
\dontrun{
data_hauls <- process_hauls(data_hauls = calas_bitacora)
data_fishing_trips <- process_fishing_trips(data_fishing_trips = faenas_bitacora)
data_length <- process_length(data_length = tallas_bitacora)

data_length_fishing_trips <- merge(
   x = data_length,
   y = data_fishing_trips,
   by = "fishing_trip_code",
   all = TRUE
)

data_total <- merge_length_fishing_trips_hauls(
   data_hauls = data_hauls,
   data_length_fishing_trips = data_length_fishing_trips
)
}

}
