% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gt2refalt}
\alias{gt2refalt}
\title{Two-letter genotype from VCF GT}
\usage{
gt2refalt(gt, ref, alt)
}
\arguments{
\item{gt}{The genotype field (must be 0/0, 0/1, or 1/1).}

\item{ref}{The reference allele.}

\item{alt}{The alternate allele.}
}
\value{
Returnvalue
}
\description{
Get a two-letter genotype from a VCF GT field. Current
  implementation is quick and dirty, and only accepts 0/0, 0/1, or 1/1. Any
  other input to gt will return a missing value.
}
\examples{
gt2refalt(gt="0/0", ref="R", alt="A")
gt2refalt(gt="0/1", ref="R", alt="A")
gt2refalt(gt="1/1", ref="R", alt="A")
gt2refalt(gt="0/2", ref="R", alt="A")
gt2refalt(gt="./.", ref="R", alt="A")
}
