% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TooManyCellsR.R
\name{importResults}
\alias{importResults}
\title{Import some 'too-many-cells make-tree' outputs into a data frame.}
\usage{
importResults(dir = "out")
}
\arguments{
\item{dir}{The output directory of a 'too-many-cells' run.}
}
\value{
A list of each output. Reads the following files, see
  \url{https://gregoryschwartz.github.io/too-many-cells/} for more details:
  "dendrogram.svg", "clumpiness.pdf", "projection.pdf",
  "label_projection.pdf", "clumpiness.csv", "cluster_info.csv",
  "node_info.csv", and "cluster_diversity.csv".
}
\description{
This function will import some of the files resulting from a 'too-many-cells
make-tree' run into R as data frames. Does not include cluster list. Look at
the main tooManyCells function for the cluster list.
}
\examples{
input <- system.file("extdata", "mat.csv", package="TooManyCellsR")
inputLabels <- system.file("extdata", "labels.csv", package="TooManyCellsR")
df = read.csv(input, row.names = 1, header = TRUE)
mat = Matrix::Matrix(as.matrix(df), sparse = TRUE)
labelsDf = read.csv(inputLabels, header = TRUE)
# Here we draw this small toy example with no filter or normalization, and
# decrease the size of the branches and increase the size of the leaf nodes.
# With non-toy real world single cell data, these options should not be
# necessary.
\dontrun{
tooManyCells( mat, labels = labelsDf
            , args = c( "make-tree"
                      , "--no-filter"
                      , "--normalization", "NoneNorm"
                      , "--draw-max-node-size", "40"
                      , "--draw-max-leaf-node-size", "70"
                      )
            )
res = importResults("out")
plot(res$treePlot, axes = FALSE)
}
}
