% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToxicoSet.R
\docType{class}
\name{ToxicoSet-class}
\alias{ToxicoSet-class}
\alias{.ToxicoSet}
\alias{cellInfo,ToxicoSet-method}
\alias{cellInfo<-,ToxicoSet,data.frame-method}
\alias{drugInfo,ToxicoSet-method}
\alias{drugInfo<-,ToxicoSet,data.frame-method}
\alias{phenoInfo,ToxicoSet,character-method}
\alias{phenoInfo<-,ToxicoSet,character,data.frame-method}
\alias{molecularProfiles,ToxicoSet,character-method}
\alias{molecularProfiles<-,ToxicoSet,character,matrix-method}
\alias{featureInfo,ToxicoSet,character-method}
\alias{featureInfo<-,ToxicoSet,character,data.frame-method}
\alias{sensitivityInfo,ToxicoSet-method}
\alias{sensitivityInfo<-,ToxicoSet,data.frame-method}
\alias{sensitivityProfiles,ToxicoSet-method}
\alias{sensitivityProfiles<-,ToxicoSet,data.frame-method}
\alias{sensitivityProfiles<-,ToxicoSet,matrix-method}
\alias{sensitivityMeasures,ToxicoSet-method}
\alias{drugNames,ToxicoSet-method}
\alias{drugNames<-,ToxicoSet,character-method}
\alias{cellNames,ToxicoSet-method}
\alias{cellNames<-,ToxicoSet,character-method}
\alias{fNames,ToxicoSet,character-method}
\alias{dateCreated,ToxicoSet-method}
\alias{cSetName,ToxicoSet-method}
\alias{pertNumber,ToxicoSet-method}
\alias{sensNumber,ToxicoSet-method}
\alias{pertNumber<-,ToxicoSet,array-method}
\alias{sensNumber<-,ToxicoSet,matrix-method}
\title{Class to contain Toxico-genomic Data}
\usage{
\S4method{cellInfo}{ToxicoSet}(cSet = tSet)

\S4method{cellInfo}{ToxicoSet,data.frame}(object) <- value

\S4method{drugInfo}{ToxicoSet}(tSet)

\S4method{drugInfo}{ToxicoSet,data.frame}(object) <- value

\S4method{phenoInfo}{ToxicoSet,character}(cSet = tSet, mDataType)

\S4method{phenoInfo}{ToxicoSet,character,data.frame}(object, mDataType) <- value

\S4method{molecularProfiles}{ToxicoSet,character}(cSet = tSet, mDataType)

\S4method{molecularProfiles}{ToxicoSet,character,matrix}(object, mDataType) <- value

\S4method{featureInfo}{ToxicoSet,character}(cSet = tSet, mDataType)

\S4method{featureInfo}{ToxicoSet,character,data.frame}(object, mDataType) <- value

\S4method{sensitivityInfo}{ToxicoSet}(cSet = tSet)

\S4method{sensitivityInfo}{ToxicoSet,data.frame}(object) <- value

\S4method{sensitivityProfiles}{ToxicoSet}(cSet = tSet)

\S4method{sensitivityProfiles}{ToxicoSet,data.frame}(object) <- value

\S4method{sensitivityProfiles}{ToxicoSet,matrix}(object) <- value

\S4method{sensitivityMeasures}{ToxicoSet}(cSet = tSet)

\S4method{drugNames}{ToxicoSet}(tSet)

\S4method{drugNames}{ToxicoSet,character}(object) <- value

\S4method{cellNames}{ToxicoSet}(cSet = tSet)

\S4method{cellNames}{ToxicoSet,character}(object) <- value

\S4method{fNames}{ToxicoSet,character}(cSet = tSet, mDataType)

\S4method{dateCreated}{ToxicoSet}(cSet = tSet)

\S4method{cSetName}{ToxicoSet}(cSet = tSet)

\S4method{pertNumber}{ToxicoSet}(cSet = tSet)

\S4method{sensNumber}{ToxicoSet}(cSet = tSet)

\S4method{pertNumber}{ToxicoSet,array}(object) <- value

\S4method{sensNumber}{ToxicoSet,matrix}(object) <- value
}
\arguments{
\item{cSet}{Parameter name for parent method inherited from CoreGx}

\item{object}{A \code{ToxicoSet} object to modify}

\item{value}{A \code{matrix} of replacement values}

\item{tSet}{A \code{ToxicoSet} object}

\item{mDataType}{\code{character} A string specifying the type of molecular
data to list the phenotype information for.}
}
\value{
An object of the ToxicoSet class

a \code{data.frame} with the cell annotations

Updated \code{ToxicoSet}

a \code{data.frame} with the experiment info

The updated \code{ToxicoSet}

Updated \code{ToxicoSet}

Updated \code{ToxicoSet}

a \code{data.frame} with the experiment info

Updated \code{ToxicoSet}
setGeneric("sensitivityInfo<-", function(object, value) standardGeneric("sensitivityInfo<-"))

a \code{data.frame} with the experiment info
setGeneric("sensitivityProfiles", function(tSet) standardGeneric("sensitivityProfiles"))

Updated \code{ToxicoSet}
setGeneric("sensitivityProfiles<-", function(object, value) standardGeneric("sensitivityProfiles<-"))

A \code{character} vector of all the available sensitivity measures

A vector of the cell names used in the ToxicoSet

Updated \code{ToxicoSet}

A \code{character} vector of the feature names

The date the ToxicoSet was created

The name of the ToxicoSet

A 3D \code{array} with the number of perturbation experiments per radiation type and cell line, and data type

A \code{data.frame} with the number of sensitivity experiments per drug and cell line

The updated \code{ToxicoSet}

The updated \code{ToxicoSet}
}
\description{
A description which has yet to be added to this class. This is just a place
holder.

A generic for cellInfo method

Generic for cellInfo replace method

Generic for phenoInfo method

Generic for phenoInfo replace method

Generic for molecularProfiles method

Generic for molecularProfiles replace method

Generic for featureInfo replace method

Generic for sensitivityInfo method

A generic for the sensitivityInfo replacement method

Generic for sensitivityProfiles method

A generic for the sensitivityProfiles replacement method

A generic for the sensitivityMeasures  method

A generic for the cellNames method

A generic for the cellNames replacement method

A generic for the fNames method

A generic for the dateCreated method

A generic for the tSetName method

A generic for the pertNumber method

A generic for the sensNumber method

A generic for the pertNumber method

A generic for the sensNumber method
}
\section{Methods (by generic)}{
\itemize{
\item \code{cellInfo}: Returns the annotations for all the cell lines tested on in the ToxicoSet

\item \code{cellInfo<-}: Update the cell line annotations

\item \code{drugInfo}: Returns the annotations for all the drugs tested in the ToxicoSet

\item \code{drugInfo<-}: Update the drug annotations

\item \code{phenoInfo}: Return the experiment info from the given type of molecular data in ToxicoSet

\item \code{phenoInfo<-}: Update the the given type of molecular data experiment info in the ToxicoSet

\item \code{molecularProfiles}: Return the given type of molecular data from the ToxicoSet

\item \code{molecularProfiles<-}: Update the given type of molecular data from the ToxicoSet

\item \code{featureInfo}: Return the feature info for the given molecular data

\item \code{featureInfo<-}: Replace the gene info for the molecular data

\item \code{sensitivityInfo}: Return the drug dose sensitivity experiment info

\item \code{sensitivityInfo<-}: Update the sensitivity experiment info

\item \code{sensitivityProfiles}: Return the phenotypic data for the drug dose sensitivity

\item \code{sensitivityProfiles<-}: Update the phenotypic data for the drug dose
sensitivity

\item \code{sensitivityProfiles<-}: Update the phenotypic data for the drug dose
sensitivity

\item \code{sensitivityMeasures}: Returns the available sensitivity profile
summaries, for example, whether there are IC50 values available

\item \code{drugNames}: Return the names of the drugs used in the ToxicoSet

\item \code{drugNames<-}: Update the drug names used in the dataset

\item \code{cellNames}: Return the cell names used in the dataset

\item \code{cellNames<-}: Update the cell names used in the dataset

\item \code{fNames}: Return the feature names used in the dataset

\item \code{dateCreated}: Return the date the ToxicoSet was created

\item \code{cSetName}: Return the name of the ToxicoSet

\item \code{pertNumber}: Return the summary of available perturbation
experiments

\item \code{sensNumber}: Return the summary of available sensitivity
experiments

\item \code{pertNumber<-}: Update the summary of available perturbation
experiments

\item \code{sensNumber<-}: Update the summary of available sensitivity
experiments
}}

\section{Slots}{

\describe{
\item{\code{drug}}{A \code{data.frame} containg the annotations for all the drugs
profiled in the in the dataset, across all data types}
}}

\examples{
data(TGGATESsmall)
cellInfo <- cellInfo(TGGATESsmall)

data(TGGATESsmall)
cellInfo(TGGATESsmall) <- cellInfo(TGGATESsmall)

data(TGGATESsmall)
phenoInfo <- phenoInfo(TGGATESsmall, mDataType="rna")

data(TGGATESsmall)
phenoInfo(TGGATESsmall, mDataType="rna") <- phenoInfo(TGGATESsmall, mDataType="rna")

data(TGGATESsmall)
TGGATES_mProf <- molecularProfiles(TGGATESsmall, "rna")[1:10,]

molecularProfiles(TGGATESsmall, "rna") <- molecularProfiles(TGGATESsmall, "rna")

data(TGGATESsmall)
featureInfo <- featureInfo(TGGATESsmall, "rna")[1:10,]

data(TGGATESsmall)
featureInfo(TGGATESsmall, "rna") <- featureInfo(TGGATESsmall, "rna")


sensInf<- sensitivityInfo(TGGATESsmall)[1:10,]

data(TGGATESsmall)
sensitivityInfo(TGGATESsmall) <- sensitivityInfo(TGGATESsmall)

data(TGGATESsmall)
sensProf <- sensitivityProfiles(TGGATESsmall)

sensitivityProfiles(TGGATESsmall) <- sensitivityProfiles(TGGATESsmall)

sensitivityMeasures(TGGATESsmall)

cellNames(TGGATESsmall)

data(TGGATESsmall)
cellNames(TGGATESsmall) <- cellNames(TGGATESsmall)

fNames(TGGATESsmall, "rna")[1:10]

dateCreated(TGGATESsmall)

tSetName <- cSetName
tSetName(TGGATESsmall)

pertNumber(TGGATESsmall)

sensNumber(TGGATESsmall)

pertNumber(TGGATESsmall) <- pertNumber(TGGATESsmall)

sensNumber(TGGATESsmall) <- sensNumber(TGGATESsmall)

}
