% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_bindings.R
\name{set_denom_where}
\alias{set_denom_where}
\title{Set Logic for denominator subsetting}
\usage{
set_denom_where(e, denom_where)
}
\arguments{
\item{e}{A Tplyr layer}

\item{denom_where}{Logic for not subsetting the target for percentage
denominator. If you don't want any subsetting, pass `TRUE` to this function.}
}
\value{
The modified Tplyr layer object
}
\description{
By default, denominators in count layers are subset based on the layer level
where logic. In some cases this might not be correct. This functions allows
the user to override this behavior and pass custom logic that will be used to
subset the target(pop_data)
}
\examples{
library(magrittr)
t10 <- tplyr_table(mtcars, gear) \%>\%
  add_layer(
    group_count(cyl, where = cyl != 6) \%>\%
    set_denom_where(TRUE)
    # The denominators will be based on all of the values, including 6
  ) \%>\%
 build()

}
