% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_bindings.R
\name{pop_data}
\alias{pop_data}
\alias{pop_data<-}
\alias{set_pop_data}
\title{Return or set population data bindings}
\usage{
pop_data(table)

pop_data(x) <- value

set_pop_data(table, pop_data)
}
\arguments{
\item{table}{A \code{tplyr_table} object}

\item{x}{A \code{tplyr_table} object}

\item{value}{A data.frame with population level information}

\item{pop_data}{A data.frame with population level information}
}
\value{
For \code{tplyr_pop_data} the pop_data binding of the
  \code{tplyr_table} object. For \code{tplyr_pop_data<-} nothing is returned,
  the pop_data binding is set silently. For \code{set_tplyr_pop_data} the
  modified object.
}
\description{
The population data is used to gather information that may not be available
from the target dataset. For example, missing treatment groups, population N
counts, and proper N counts for denominators will be provided through the
population dataset. The population dataset defaults to the target dataset
unless otherwise specified using \code{set_pop_data}.
}
\examples{
tab <- tplyr_table(iris, Species)

pop_data(tab) <- mtcars

tab <- tplyr_table(iris, Species) \%>\%
  set_pop_data(mtcars)
}
