% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FX.R
\name{FxForward-class}

\alias{FxForward}
\title{FX Forward Class}
\arguments{
\item{Notional}{The notional amount of the trade}

\item{MTM}{The mark-to-market valuation of the trade}

\item{Currency}{The currency that the input amounts are in}

\item{ccyPair}{The currency Pair of the trade}

\item{Si}{The number of years that the trade will take to start (zero if already started)}

\item{Ei}{The number of years that the trade will expire}

\item{BuySell}{Takes the values of either 'Buy' or 'Sell'}

\item{traded_price}{the price that trade was done}
}
\value{
An object of type FX Forward
}
\description{
Creates a FX Forward Object with the relevant info needed to calculate the Exposure-at-Default (EAD)
}

\examples{

## a FX Forward trade 
tr1 = FxForward(Notional=10000,MtM=-50,Si=0,Ei=0.75,BuySell='Buy',ccyPair="EUR/USD")
}
\references{
Basel Committee: The standardised approach for measuring counterparty credit risk exposures
http://www.bis.org/publ/bcbs279.htm
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
