% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DouglasPeucker.R
\docType{methods}
\name{douglasPeucker}
\alias{douglasPeucker}
\alias{douglasPeucker,Track,numeric-method}
\title{Douglas Peucker}
\usage{
douglasPeucker(A1, dist)

\S4method{douglasPeucker}{Track,numeric}(A1, dist)
}
\arguments{
\item{A1}{Represents a single trajectory followed by a person, animal or object}

\item{dist}{Distance time series}
}
\value{
reduces trajectories by preserving spatial precisions
}
\description{
Douglas-Peucker which reduces trajectories by preserving spatial precisions
}
\examples{

\dontrun{
library(ggplot2)

dist <- max(A1@connections$distance)

douglasp <- douglasPeucker(A1,dist)

df <- data.frame(x=douglasp@sp@coords[,1],y=douglasp@sp@coords[,2])
ggplot(df,aes(x=df$x,y=df$y))+geom_path(aes(group = 1))
}
}
\author{
Diego Monteiro
}
