## ----init, echo=FALSE, warning=FALSE------------------------------------------
standardMargin <- c(0.4, 0.4, 0.8, 0.4)
cbPalette8 <- c("#000000", "#E69F00", "#56B4E9", "#009E73", "#F0E442",
                "#0072B2", "#D55E00", "#CC79A7")

## ----Tree-distance-averages, echo=FALSE, message=FALSE, cache=TRUE, fig.asp=2, fig.width=6, fig.align='center'----
if (requireNamespace('TreeDistData', quietly = TRUE)) {
  library('TreeDistData')
  data('tdMethods', package = 'TreeDistData')
  data('tdAbbrevs', package = 'TreeDistData')
  methods <- tdMethods
  abbrevs <- tdAbbrevs
  
  totalInfoContent <- 3L
  methodLCH <- colorspace::coords(as(colorspace::hex2RGB(TreeDistCol(methods)), 'polarLUV'))
  
  data('randomTreeDistances', package = 'TreeDistData')
  pathMax <- randomTreeDistances['path', 'max', ]
  msdMax <- randomTreeDistances['ms', 'max', ]
  nniMax <- randomTreeDistances['nni_u', 'max', ]
  tbrMax <- randomTreeDistances['tbr_u', 'max', ]
  
  nTip <- as.integer(dimnames(randomTreeDistances)[[3]])
  
  pathNorm <- nls(pathMax ~ a * (nTip ^2) + b * (nTip ^3) + nTip ^ c,
                  start = list(a = -0.0444, b = 4.6e-5, c = 1.478))
  
  msdNorm <- nls(msdMax ~ (a * nTip) + (c * nTip ^ b) + d,
                 start = list(a = -16.795, b = 1.135, c = 14.25, d = 1.86))
  
  nniNorm <-  nls(nniMax ~ (a * nTip) + (c * nTip ^ b) + d + e * (nTip ^ 2) + f * (nTip ^ 3),
                  start = list(a = -16.7, b = 1.1, c = 14, d = 6, e = 0.01, f = 0.01))
  
  #tbrNorm <-  nls(tbrMax ~ (a * nTip) + (c * nTip ^ b) + d + e * (nTip ^2) + f * (nTip ^3),
  #                start = list(a = 1, b = 1, c = 0.01, d = 1, e = 0.01, f = 0.01))
  tbrNorm <-  lm(tbrMax ~ nTip)
  
  
  normalizeAgainst <- rbind(
    path = predict(pathNorm),
    msd = predict(msdNorm),
    nni_u = predict(nniNorm),
    nni_l = predict(nniNorm),
    spr = nTip / 2L,
    tbr_u = nTip,
    tbr_l = nTip,
    rf = (nTip - 3L) * 2L,
    mast = nTip,
    masti = TreeTools::LnUnrooted(nTip) / log(2)
  )
  
  AddLine <- function (method, normalize = FALSE) {
    dat <- randomTreeDistances[method, , ]
    dat <- dat[, !is.na(dat[1, ])]
    nLeaves <- colnames(dat)
    if (normalize) dat <- dat / rep(normalizeAgainst[method, ], each = dim(dat)[1L])
    Invert <- function (dat) {
      dat['mean', ] <- 1 - dat['mean', ]
      dat[c("min", "1%", "5%", "10%", "25%", "50%", "75%", "90%", "95%", 
            "99%", "max"), ] <- 1 - 
        dat[c("max", "99%", "95%", "90%", "75%", "50%", "25%", 
              "10%", "5%", "1%", "min"), ]
      dat
    }
    if (method %in% c('mast', 'masti')) dat <- Invert(dat)
    
    col <- TreeDistCol(method, '')
    
    lines(nLeaves, dat['50%', ], pch = 1, col = col)
    polygon(c(nLeaves, rev(nLeaves)), c(dat['10%', ], rev(dat['90%', ])),
            border = NA, col = paste0(col, '33'),)
    polygon(c(nLeaves, rev(nLeaves)), c(dat['25%', ], rev(dat['75%', ])),
            border = NA, col = paste0(col, '33'),)
    #lines(nLeaves, dat['25%', ], lty = 2, col = col)
    #lines(nLeaves, dat['75%', ], lty = 2, col = col)
    #pointsAt <- 1:10 * 20L
  }
  
  oldPar <- par(mfrow = c(3, 1), cex = 0.7, oma = rep(0, 4),
                mar = c(5, 5, 0.01, 0.01))
  PlotMethods <- function (methods, yMin = 0.4,
                           lp = c('bottomright', 'bottomleft')) {
    plot(as.integer(dimnames(randomTreeDistances)[[3]]),
         randomTreeDistances['pid', 'mean', ],
         ylim = c(yMin, 1), type = 'n',
         xlab = "Number of leaves", ylab = "Normalized tree distance")
    for (method in methods) AddLine(method, 
                                    method %in% c('msd', rownames(normalizeAgainst)))
    
    
    legend(lp[1], bty = 'n',
           lty = 1, legend = abbrevs[methods], col = TreeDistCol(methods, 44),
           text.col = '#FFFFFFFF', pch = 15, pt.cex = 1.8
    )
    
    legend(lp[1], bty = 'n', lty = 1, 
           legend = abbrevs[methods], col = TreeDistCol(methods))
    
    legend(lp[2], bty = 'n', inset = c(0.09, 0),
           lty = 1, lwd = c(1, 4, 6), col = c(1, "#00000066", "#00000033"),
           legend = c('Median', 'Interquartile range', 'Interdecile range'))
  }
  PlotMethods(c('rf', 'pid', 'cid', 'ms', 'nye', 'msid'))
  PlotMethods(c('rf', 'jnc4', 'jco4', 'jnc2', 'jco2', 'nye'), yMin = 0.7)
  PlotMethods(c('nni_u', 'tbr_u', 'spr', 'masti', 'mast',
                'path', 'qd', 'tbr_l', 'nni_l'), yMin = 0.14, 
              lp = c('bottomright', 'right'))
  par(oldPar)
} else {
  cat("\nInstall package 'TreeDistData' to render this chart.")
}

