% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance.R
\name{SplitsCompatible}
\alias{SplitsCompatible}
\title{Are splits compatible?}
\usage{
SplitsCompatible(split1, split2)
}
\arguments{
\item{split1, split2}{Logical vectors listing leaves in a consistent order,
identifying each leaf as a member of the ingroup (\code{TRUE}) or outgroup
(\code{FALSE}) of the split in question.}
}
\value{
\code{SplitsCompatible()} returns a logical specifying whether the splits
provided are compatible with one another.
}
\description{
Determine whether splits are compatible (concave); i.e. they can both occur
on a single tree.
}
\examples{
A <- TRUE
B <- FALSE
SplitsCompatible(c(A, A, A, B, B, B),
                 c(A, A, B, B, B, B))
SplitsCompatible(c(A, A, A, B, B, B),
                 c(A, A, B, B, B, A))
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
