% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_metrics_methods.R
\name{fastPointMetrics}
\alias{fastPointMetrics}
\title{Calculate point neighborhood metrics}
\usage{
fastPointMetrics(
  las,
  method = ptm.voxel(),
  which_metrics = ENABLED_POINT_METRICS$names
)
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{method}{neighborhood search algorithm. Currently available: \code{\link{ptm.voxel}} and \code{\link{ptm.knn}}.}

\item{which_metrics}{optional \code{character} vector - list of metrics (by name) to be calculated. Check out \code{\link{fastPointMetrics.available}} for a list of all metrics.}
}
\value{
\code{\link[lidR:LAS]{LAS}} object.
}
\description{
Get statistics for every point in a \code{LAS} object. Neighborhood search methods are prefixed by \code{ptm}.
}
\details{
Individual or voxel-wise point metrics build up the basis for many studies involving TLS in forestry. This
function is used internally in other \emph{TreeLS} methods for tree mapping and stem denoising, but also may
be useful to users interested in developing their own custom methods for point cloud classification/filtering of
vegetation features or build up input datasets for machine learning classifiers.

\code{fastPointMetrics} provides a way to calculate several geometry related metrics (listed below) in an optimized way.
All metrics are calculated internally by C++ functions in a single pass (\emph{O(n)} time), hence \emph{fast}.
This function is provided for convenience, as it allows very fast calculations of several complex variables
on a single line of code, speeding up heavy work loads. For a more flexible approach that allows user defined
metrics check out \code{\link[lidR:point_metrics]{point_metrics}} from the \emph{lidR} package.

In order to avoid excessive memory use, not all available metrics are calculated by default.
The calculated metrics can be specified every time \code{fastPointMetrics} is run by naming the desired metrics
into the \code{which_metrics} argument, or changed globally for the active R session by setting new default
metrics using \code{\link{fastPointMetrics.available}}.
}
\section{List of available point metrics}{


\loadmathjax

* \emph{EVi} = \emph{i}-th 3D eigen value 

* \emph{EV2Di} = \emph{i}-th 2D eigen value

\itemize{
   \item \code{N}: number of nearest neighbors
   \item \code{MinDist}: minimum distance among neighbors 
   \item \code{MaxDist}: maximum distance among neighbors
   \item \code{MeanDist}: mean distance
   \item \code{SdDist}: standard deviation of within neighborhood distances
   \item \code{Linearity}: linear saliency, \mjeqn{(EV_{1} + EV_{2}) / EV_{1}}{(EV1 + EV2) / EV1}
   \item \code{Planarity}: planar saliency, \mjeqn{(EV_{2} + EV_{3}) / EV_{1}}{(EV2 + EV3) / EV1}
   \item \code{Scattering}: \mjeqn{EV_{3} / EV_{1}}{EV3 / EV1}
   \item \code{Omnivariance}: \mjeqn{(EV_{2} + EV_{3}) / EV_{1}}{(EV2 + EV3) / EV1}
   \item \code{Anisotropy}: \mjeqn{(EV_{1} - EV_{3}) / EV_{1}}{(EV1 - EV3) / EV1}
   \item \code{Eigentropy}: \mjeqn{- \sum_{i=1}^{n=3} EV_{i} * ln(EV_{i})}{-sum(EV * ln(EV))}
   \item \code{EigenSum}: sum of eigenvalues, \mjeqn{\sum_{i=1}^{n=3} EV_{i}}{sum(EV)}
   \item \code{Curvature}: surface variation, \mjeqn{EV_{3} / EigenSum}{EV3 / EigenSum}
   \item \code{KnnRadius}: 3D neighborhood radius
   \item \code{KnnDensity}: 3D point density (N / sphere volume)
   \item \code{Verticality}: absolute vertical deviation, in degrees 
   \item \code{ZRange}: point neighborhood height difference
   \item \code{ZSd}: standard deviation of point neighborhood heights
   \item \code{KnnRadius2d}: 2D neighborhood radius 
   \item \code{KnnDensity2d}: 2D point density (N / circle area)
   \item \code{EigenSum2d}: sum of 2D eigenvalues, \mjeqn{\sum_{i=1}^{n=2} EV2D_{i}}{sum(EV2D)}
   \item \code{EigenRatio2d}: \mjeqn{EV2D_{2} / EV2D_{1}}{EV2D2 / EV2D1}
   \item \code{EigenValuei}: 3D eigenvalues
   \item \code{EigenVectorij}: 3D eigenvector coefficients, \emph{i}-th load of \emph{j}-th eigenvector
}
}

\examples{
file = system.file("extdata", "pine.laz", package="TreeLS")
tls = readTLS(file, select='xyz')

all_metrics = fastPointMetrics.available()
my_metrics = all_metrics[c(1,4,6)]

tls = fastPointMetrics(tls, ptm.knn(10), my_metrics)
head(tls@data)
plot(tls, color='Linearity')
}
\references{
Wang, D.; Hollaus, M.; Pfeifer, N., 2017. Feasibility of machine learning methods for separating wood and leaf points from terrestrial laser scanning data. ISPRS Annals of the Photogrammetry, Remote Sensing and Spatial Information Sciences, Volume IV-2/W4.

Zhou, J. et. al., 2019. Separating leaf and wood points in terrestrial scanning data using multiple optimal scales. Sensors, 19(8):1852.
}
