% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sectorial.R
\name{DoSectorial}
\alias{DoSectorial}
\title{Sectorial Search with inapplicable data}
\usage{
DoSectorial(tree, dataset, TreeScorer = FitchScore, maxSectIter = 100,
  maxIter = 500, maxImprovements = 5, smallestSector = 4,
  largestSector = 1e+06, Rearrangements = list(RootedNNI), verbosity = 0,
  ...)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}, with internal numbering in cladewise order
(use \code{\link{Preorder}(tree)} or (slower) \code{\link{Cladewise}(tree)})}

\item{dataset}{a dataset in the format expected by \code{TreeScorer}}

\item{TreeScorer}{a function that will score a tree topology}

\item{maxSectIter}{maximum number of sectorial iterations to perform}

\item{maxIter}{maximum number of iterations to perform in tree rearrangement functions}

\item{maxImprovements}{maximum number of times to find an optimal score before ending sectorial search}

\item{smallestSector}{integer giving size of smallest sector to rearrange}

\item{largestSector}{integer giving size of largest sector to rearrange (rounded down if non-integral)}

\item{Rearrangements}{a list of tree rearrangement functions that retain the root of the tree
(e.g. \code{list(RootedSPR)})}

\item{verbosity}{verbosity of output written to terminal; higher values print more messages}

\item{\dots}{further arguments to pass to \code{TreeScorer} function (e.g. \code{\link{TipsAreColumns}}, \code{dataset})}
}
\value{
a tree of class \code{phylo} with a \code{TreeScorer} score as good or better than that of \code{tree}
}
\description{
\code{DoSectorial} is called by Sectorial
}
\author{
Martin R. Smith
}
