% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{MorphyBootstrap}
\alias{MorphyBootstrap}
\alias{ProfileBootstrap}
\alias{IWBootstrap}
\title{Ratchet bootstrapper}
\usage{
MorphyBootstrap(edgeList, morphyObj, EdgeSwapper = NNISwap, maxIter, maxHits,
  verbosity = 1L, ...)

ProfileBootstrap(edgeList, dataset, EdgeSwapper = NNISwap, maxIter, maxHits,
  verbosity = 1L, ...)

IWBootstrap(edgeList, dataset, concavity = 4L, EdgeSwapper = NNISwap,
  maxIter, maxHits, verbosity = 1L, ...)
}
\arguments{
\item{edgeList}{a list containing the following:
- vector of integers corresponding to the parent of each edge in turn
- vector of integers corresponding to the child of each edge in turn
- (optionally) score of the tree
- (optionally, if score provided) number of times this score has been hit}

\item{morphyObj}{A morphy object, perhaps created with \code{\link{PhyDat2Morphy}}.}

\item{EdgeSwapper}{a function that rearranges a parent and child vector, 
and returns a list with modified vectors; for example
\code{\link{SPRSwap}}.}

\item{maxIter}{maximum number of iterations to perform in tree search}

\item{maxHits}{maximum number of hits to accomplish in tree search}

\item{verbosity}{Level of detail to display in console: larger numbers provide
more verbose feedback to the user.}

\item{\dots}{further parameters to send to \code{TreeScorer}}

\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}}, whose names 
correspond to the labels of any accompanying tree.}

\item{concavity}{A numeric value to use as the concavity constant (`k`) in implied weighting.}
}
\value{
A tree that is optimal under a random sampling of the original characters
}
\description{
Ratchet bootstrapper
}
\section{Functions}{
\itemize{
\item \code{ProfileBootstrap}: Bootstrapper for Profile Parsimony

\item \code{IWBootstrap}: Bootstrapper for Implied weighting
}}

