% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_manipulation.R
\name{MinimumLength}
\alias{MinimumLength}
\alias{MinimumLength.phyDat}
\alias{MinimumLength.numeric}
\alias{MinimumSteps}
\title{Minimum length}
\usage{
MinimumLength(x, compress = FALSE)

\method{MinimumLength}{phyDat}(x, compress = FALSE)

\method{MinimumLength}{numeric}(x, compress = NA)

MinimumSteps(x)
}
\arguments{
\item{x}{An object of class \code{phyDat},
or an integer vector listing the tokens that may be present at each
tip along a single character, with each token represented as a binary digit;
e.g. a value of 11 ( = 2^0 + 2^1 + 2^3) means that
the tip may have tokens 0, 1 or 3.

Inapplicable tokens should be denoted with the integer \code{0} (not 2^0).

Tokens that are ambiguous for an inapplicable and an applicable
state are not presently supported; for an approximate value, denote such
ambiguity with the integer \code{0}.}

\item{compress}{Logical specifying whether to retain the compression of a
\code{phyDat} object or to return a vector specifying to each individual
character, decompressed using the dataset's \code{index} attribute.}
}
\value{
\code{MinimumLength()} returns a vector of integers specifying the
minimum number of steps that each character must contain.
}
\description{
The smallest length that a character can obtain on any tree.
}
\examples{
data('inapplicable.datasets')
myPhyDat <- inapplicable.phyData[[4]] 
MinimumLength(myPhyDat)
MinimumLength(myPhyDat, compress = TRUE)


class(myPhyDat) # phyDat object
# load your own data with
# my.PhyDat <- as.phyDat(read.nexus.data('filepath'))
# or Windows users can select a file interactively using:
# my.PhyDat <- as.phyDat(read.nexus.data(choose.files()))

# Convert list of character codings to an array
myData <- vapply(myPhyDat, I, myPhyDat[[1]])

# Convert phyDat's representation of states to binary
myContrast <- attr(myPhyDat, 'contrast')
tokens <- colnames(myContrast)
binaryContrast <- integer(length(tokens))
tokenApplicable <- tokens != '-'
binaryContrast[tokenApplicable] <- 2 ^ (seq_len(sum(tokenApplicable)) - 1)
binaryValues <- apply(myContrast, 1, 
  function (row) sum(binaryContrast[as.logical(row)]))
myStates <- matrix(binaryValues[myData], nrow = nrow(myData),
                   ncol = ncol(myData), dimnames = dimnames(myData))

# Finally, work out minimum steps 
apply(myStates, 1, MinimumLength)
}
\seealso{
Other tree scoring: 
\code{\link{CharacterLength}()},
\code{\link{IWScore}()},
\code{\link{MorphyTreeLength}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree scoring}
