% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R, R/Ratchet.R
\name{MorphyBootstrap}
\alias{MorphyBootstrap}
\alias{Ratchet}
\alias{MultiRatchet}
\alias{RatchetConsensus}
\title{Parsimony Ratchet}
\usage{
MorphyBootstrap(
  edgeList,
  morphyObj,
  EdgeSwapper = NNISwap,
  maxIter,
  maxHits,
  verbosity = 1L,
  stopAtPeak = FALSE,
  stopAtPlateau = 0L,
  ...
)

Ratchet(
  tree,
  dataset,
  InitializeData = PhyDat2Morphy,
  CleanUpData = UnloadMorphy,
  TreeScorer = MorphyLength,
  Bootstrapper = MorphyBootstrap,
  swappers = list(TBRSwap, SPRSwap, NNISwap),
  BootstrapSwapper = if (is.list(swappers)) swappers[[length(swappers)]] else swappers,
  returnAll = FALSE,
  stopAtScore = NULL,
  stopAtPeak = FALSE,
  stopAtPlateau = 0L,
  ratchIter = 100,
  ratchHits = 10,
  searchIter = 4000,
  searchHits = 42,
  bootstrapIter = searchIter,
  bootstrapHits = searchHits,
  verbosity = 1L,
  suboptimal = sqrt(.Machine$double.eps),
  ...
)

MultiRatchet(
  tree,
  dataset,
  ratchHits = 10,
  searchIter = 500,
  searchHits = 20,
  verbosity = 0L,
  swappers = list(RootedNNISwap),
  nSearch = 10,
  stopAtScore = NULL,
  ...
)

RatchetConsensus(
  tree,
  dataset,
  ratchHits = 10,
  searchIter = 500,
  searchHits = 20,
  verbosity = 0L,
  swappers = list(RootedNNISwap),
  nSearch = 10,
  stopAtScore = NULL,
  ...
)
}
\arguments{
\item{edgeList}{a list containing the following:
- vector of integers corresponding to the parent of each edge in turn
- vector of integers corresponding to the child of each edge in turn
- (optionally) score of the tree
- (optionally, if score provided) number of times this score has been hit}

\item{morphyObj}{Object of class \code{morphy}, perhaps created with
\code{\link[=PhyDat2Morphy]{PhyDat2Morphy()}}.}

\item{EdgeSwapper}{a function that rearranges a parent and child vector,
and returns a list with modified vectors; for example \code{\link[=SPRSwap]{SPRSwap()}}.}

\item{maxIter}{Numeric specifying maximum number of iterations to perform in
tree search.}

\item{maxHits}{Numeric specifying maximum number of hits to accomplish in
tree search.}

\item{verbosity}{Numeric specifying level of detail to display in console:
larger numbers provide more verbose feedback to the user.}

\item{stopAtPeak}{Logical specifying whether to terminate search once a
subsequent iteration recovers a sub-optimal score.
Will be overridden if a passed function has an attribute \code{stopAtPeak} set by
\code{attr(FunctionName, 'stopAtPeak') <- TRUE}.}

\item{stopAtPlateau}{Integer. If > 0, tree search will terminate if the score
has not improved after \code{stopAtPlateau} iterations.
Will be overridden if a passed function has an attribute \code{stopAtPlateau} set
by \code{attr(FunctionName, 'stopAtPlateau') <- TRUE}.}

\item{\dots}{further arguments to pass to \code{TreeScorer()}, e.g. \verb{dataset = }.}

\item{tree}{A tree of class \code{\link{phylo}}.}

\item{dataset}{a dataset in the format required by \code{TreeScorer()}.}

\item{InitializeData}{Function that sets up data object to prepare for tree search.
The function will be passed the \code{dataset} parameter.
Its return value will be passed to \code{TreeScorer()} and \code{CleanUpData()}.}

\item{CleanUpData}{Function to destroy data object on function exit.
The function will be passed the value returned by \code{InitializeData()}.}

\item{TreeScorer}{function to score a given tree.
The function will be passed three parameters, corresponding to the
\code{parent} and \code{child} entries of a tree's edge list, and a dataset.}

\item{Bootstrapper}{Function to perform bootstrapped rearrangements of tree.
First arguments will be an \code{edgeList} and a dataset, initialized using
\code{InitializeData()}. Should return a rearranged \code{edgeList}.}

\item{swappers}{A list of functions to use to conduct edge rearrangement during tree search.
Provide functions like \code{\link{NNISwap}} to shuffle root position,
or \code{\link{RootedTBRSwap}} if the position of the root should be retained.
You may wish to use extreme swappers (such as \acronym{TBR}) early in the list,
and a more subtle rearranger (such as \acronym{NNI}) later in the list to make
incremental tinkerings once an almost-optimal tree has been found.}

\item{BootstrapSwapper}{Function such as \code{\link{RootedNNISwap}} to use
to rearrange trees within \code{Bootstrapper()}.}

\item{returnAll}{Set to \code{TRUE} to report all MPTs encountered during the
search, perhaps to analyse consensus.}

\item{stopAtScore}{stop search as soon as this score is hit or beaten.}

\item{ratchIter}{Stop when this many ratchet iterations have been performed.}

\item{ratchHits}{Stop when this many ratchet iterations have found the same
best score.}

\item{searchIter}{Integer specifying maximum rearrangements to perform on each bootstrap or
ratchet iteration.
To override this value for a single swapper function, set e.g.
\code{attr(SwapperFunction, 'searchIter') <- 99}}

\item{searchHits}{Integer specifying maximum times to hit best score before terminating a tree
search within a ratchet iteration.
To override this value for a single swapper function, set e.g.
\code{attr(SwapperFunction, 'searchHits') <- 99}}

\item{bootstrapIter}{Integer specifying maximum rearrangements to perform on each bootstrap
iteration (default: \code{searchIter}).}

\item{bootstrapHits}{Integer specifying maximum times to hit best score on each bootstrap
iteration (default: \code{searchHits}).}

\item{suboptimal}{retain trees that are suboptimal by this score.
Defaults to a small value that will counter rounding errors.}

\item{nSearch}{Number of Ratchet searches to conduct
(for \code{RatchetConsensus()})}
}
\value{
\code{MorphyBootstrap()} returns a tree that is optimal under a random
sampling of the original characters.

\code{Ratchet()} returns a tree modified by parsimony ratchet iterations.

\code{MultiRatchet()} returns a list of optimal trees
produced by \code{nSearch}
ratchet searches, from which a consensus tree can be generated using
\code{\link[ape:consensus]{ape::consensus()}} or \code{\link[TreeTools:ConsensusWithout]{TreeTools::ConsensusWithout()}}.
}
\description{
\code{Ratchet()} uses the parsimony ratchet \insertCite{Nixon1999}{TreeSearch}
to search for a more parsimonious tree using custom optimality criteria.
}
\details{
For usage pointers, see the
\href{https://ms609.github.io/TreeSearch/articles/custom.html}{vignette}.
}
\section{Functions}{
\itemize{
\item \code{RatchetConsensus()}: deprecated alias for \code{MultiRatchet()}

}}
\examples{
data('Lobo', package = 'TreeTools')
njtree <- TreeTools::NJTree(Lobo.phy)
# Increase value of ratchIter and searchHits to do a proper search
quickResult <- Ratchet(njtree, Lobo.phy, ratchIter = 2, searchHits = 3)

# Plot result (legibly)
oldPar <- par(mar = rep(0, 4), cex = 0.75)
plot(quickResult)
par(oldPar)
}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item Adapted from \code{\link[phangorn:parsimony]{pratchet()}} in the
\pkg{phangorn} package.
}

Other custom search functions: 
\code{\link{EdgeListSearch}()},
\code{\link{Jackknife}()},
\code{\link{SuccessiveApproximations}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{custom search functions}
