% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterStrings.R
\name{ClusterStrings}
\alias{ClusterStrings}
\title{Cluster similar strings}
\usage{
ClusterStrings(x, maxCluster = 12)
}
\arguments{
\item{x}{Character vector.}

\item{maxCluster}{Integer specifying maximum number of clusters to consider.}
}
\value{
\code{NameClusters()} returns an integer assigning each element of \code{x}
to a cluster, with an attribute \code{med} specifying the median string in each
cluster, and \code{silhouette} reporting the silhouette coefficient of the optimal
clustering.  Coefficients < 0.5 indicate weak structure, and no clusters are
returned.  If the number of unique elements of \code{x} is less than \code{maxCluster},
all occurrences of each entry are assigned to an individual cluster.
}
\description{
Calculate string similarity using the Levenshtein distance and return
clusters of similar strings.
}
\examples{
ClusterStrings(c(paste0("FirstCluster ", 1:5),
                 paste0("SecondCluster.", 8:12),
                 paste0("AnotherCluster_", letters[1:6])))
}
\seealso{
Other utility functions: 
\code{\link{QuartetResolution}()},
\code{\link{WhenFirstHit}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{utility functions}
