% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_numbering.R
\name{RenumberTips}
\alias{RenumberTips}
\alias{RenumberTips.phylo}
\alias{RenumberTips.multiPhylo}
\alias{RenumberTips.list}
\title{Renumber a tree's tips}
\usage{
RenumberTips(tree, tipOrder)

\method{RenumberTips}{phylo}(tree, tipOrder)

\method{RenumberTips}{multiPhylo}(tree, tipOrder)

\method{RenumberTips}{list}(tree, tipOrder)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{tipOrder}{A character vector containing the values of
\code{tree$tip.label} in the desired sort order, or an object
(perhaps of class \code{phylo} or \code{Splits}) with tip labels.}
}
\value{
\code{RenumberTips} returns \code{tree1}, with the tips' internal
representation numbered to match \code{tipOrder}.
}
\description{
\code{RenumberTips(tree, tipOrder)} sorts the tips of a phylogenetic tree
such that the indices in \code{tree$edge[, 2]} correspond to the order of
tips given in \code{tipOrder}.
}
\examples{
data('Lobo') # Loads the phyDat object Lobo.phy
tree <- RandomTree(Lobo.phy)
tree <- RenumberTips(tree, names(Lobo.phy))

}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
