% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_shape.R
\name{TreeShape}
\alias{TreeShape}
\alias{RootedTreeShape}
\alias{RootedTreeWithShape}
\alias{UnrootedTreeWithShape}
\alias{UnrootedTreeWithKey}
\alias{UnrootedTreeShape}
\alias{UnrootedTreeKey}
\alias{.UnrootedKeys}
\alias{UnrootedKeys}
\alias{NUnrootedShapes}
\alias{NRootedShapes}
\title{Integer representing shape of a tree}
\usage{
RootedTreeShape(tree)

RootedTreeWithShape(shape, nTip, tipLabels = rep("", nTip))

UnrootedTreeWithShape(shape, nTip, tipLabels = rep("", nTip))

UnrootedTreeWithKey(key, nTip, tipLabels = rep("", nTip))

UnrootedTreeShape(tree)

UnrootedTreeKey(tree)

.UnrootedKeys(nTip)

UnrootedKeys(..., envir = parent.frame())

NUnrootedShapes(nTip)

NRootedShapes(nTip)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{shape}{Integer specifying shape of tree, perhaps generated by
\code{TreeShape}.}

\item{nTip}{Integer specifying number of tips.}

\item{tipLabels}{Character vector listing the labels assigned to each tip
in a tree, perhaps obtained using \link{TipLabels}.}

\item{key}{Integer specifying the \emph{key} (not number) of an unrooted tree.}

\item{\dots}{Value of \code{nTip}, to pass to memoized \code{.UnrootedKeys}.}

\item{envir}{Unused; passed to \code{\link{addMemoization}}.}
}
\value{
\code{TreeShape} returns an integer specifying the shape of a tree,
ignoring tip labels.

\code{RootedTreeWithShape} returns a tree of class \code{phylo} corresponding to the
shape provided.  Tips are unlabelled.

\code{UnrootedTreeWithShape} returns a tree of class \code{phylo} corresponding
to the shape provided.  Tips are unlabelled.

\code{UnrootedTreeWithKey} returns a tree of class \code{phylo} corresponding
to the key provided.  Tips are unlabelled.

\code{UnrootedKeys} returns a vector of integers corresponding to the
keys (not shape numbers) of unrooted tree shapes with \code{nTip} tips.
It is a wrapper to \code{.UnrootedKeys}, with memoization, meaning that results
once calculated are cached and need not be calculated on future calls to
the function.

\code{TreeShapes} returns an integer specifying the number of unique
unrooted tree shapes with \code{nTip} tips.

\code{RootedTreeShapes} returns an integer specifying the number of unique
rooted tree shapes with \code{nTip} tips.
}
\description{
Returns an integer that uniquely represents the shape of an \emph{n}-tip
binary tree, ignoring tip labels.
}
\details{
Rooted trees are numbered working up from the root.

The root node divides \emph{n} tips into two subtrees.  The smaller subtree
may contain $a = 1, 2, ..., n/2$ tips, leaving $b = n - a$ tips in
These options are worked through in turn.

For the first shape of the smaller subtree, work through each possible shape
for the larger subtree.  Then, move to the next shape of the smaller subtree,
and work through each possible shape of the larger subtree.

Stop when the desired topology is encountered.

Unrooted trees are numbered less elegantly.  Each cherry (i.e. node
subtending a pair of tips) is treated in turn.  The subtended tips are
removed, and the node treated as the root of a rooted tree.  The number of
this rooted tree is then calculated.  The tree is assigned a \emph{key}
corresponding to the lowest such value.  The keys of all unrooted tree shapes
on \emph{n} tips are ranked, and the unrooted tree shape is assigned a \emph{number}
based on the rank order of its key among all possible keys, counting from
zero.

If \code{UnrootedTreeShape} or \code{UnrootedTreeKey} is passed a rooted tree,
the position of the root will be ignored.
}
\examples{
RootedTreeShape(PectinateTree(8))
plot(RootedTreeWithShape(0, nTip = 8L))

NRootedShapes(8L)
# Shapes are numbered from 0 to NRootedShapes(n) - 1.  The maximum shape is:
RootedTreeShape(BalancedTree(8))

# Unique shapes of unrooted trees:
NUnrootedShapes(8L)

# Keys of these trees:
UnrootedKeys(8L)

# A tree may be represented by multiple keys.
# For a one-to-one correspondence, use a number instead:
allShapes <- lapply(seq_len(NUnrootedShapes(8L)) - 1L,
                    UnrootedTreeWithShape, 8L)
plot(allShapes[[1]])
sapply(allShapes, UnrootedTreeShape)
sapply(allShapes, UnrootedTreeKey) # Key >= number


}
\seealso{
\code{\link{TreeNumber}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\keyword{internal}
