% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{SampleOne}
\alias{SampleOne}
\title{Select element at random}
\usage{
SampleOne(x, len = length(x))
}
\arguments{
\item{x}{A vector to sample.}

\item{len}{(Optional) Integer specifying length of \code{x}.}
}
\value{
\code{SampleOne()} returns a length one vector, randomly sampled from \code{x}.
}
\description{
\code{SampleOne()} is a fast alternative to  \code{\link[=sample]{sample()}} that avoids some checks.
}
\examples{
SampleOne(9:10)
SampleOne(letters[1:4])

}
\seealso{
Other utility functions: 
\code{\link{ClusterTable}},
\code{\link{ClusterTable-methods}},
\code{\link{Hamming}()},
\code{\link{MSTEdges}()},
\code{\link{TipTimedTree}()},
\code{\link{UnshiftTree}()},
\code{\link{as.multiPhylo}()},
\code{\link{match,phylo,phylo-method}},
\code{\link{sapply64}()},
\code{\link{sort.multiPhylo}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{utility functions}
