% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_properties.R
\name{SplitsInBinaryTree}
\alias{SplitsInBinaryTree}
\alias{SplitsInBinaryTree.list}
\alias{SplitsInBinaryTree.multiPhylo}
\alias{SplitsInBinaryTree.numeric}
\alias{SplitsInBinaryTree.NULL}
\alias{SplitsInBinaryTree.default}
\alias{SplitsInBinaryTree.Splits}
\alias{SplitsInBinaryTree.phylo}
\title{Maximum splits in an \emph{n}-leaf tree}
\usage{
SplitsInBinaryTree(tree)

\method{SplitsInBinaryTree}{list}(tree)

\method{SplitsInBinaryTree}{multiPhylo}(tree)

\method{SplitsInBinaryTree}{numeric}(tree)

\method{SplitsInBinaryTree}{`NULL`}(tree)

\method{SplitsInBinaryTree}{default}(tree)

\method{SplitsInBinaryTree}{Splits}(tree)

\method{SplitsInBinaryTree}{phylo}(tree)
}
\arguments{
\item{tree}{An object of a supported format that represents a tree or
set of trees, from which the number of leaves will be calculated.}
}
\value{
\code{SplitsInBinaryTree()} returns an integer vector detailing the number
of unique non-trivial splits in a binary tree with \emph{n} leaves.
}
\description{
\code{SplitsInBinaryTree()} is a convenience function to calculate the number of
splits in a fully-resolved (binary) tree with \emph{n} leaves.
}
\examples{
tree <- BalancedTree(8)
SplitsInBinaryTree(tree)
SplitsInBinaryTree(as.Splits(tree))
SplitsInBinaryTree(8)
SplitsInBinaryTree(list(tree, tree))
}
\seealso{
Other tree properties: 
\code{\link{ConsensusWithout}()},
\code{\link{MatchEdges}()},
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{NodeNumbers}()},
\code{\link{PathLengths}()},
\code{\link{TipLabels}()},
\code{\link{TreeIsRooted}()}

Other Splits operations: 
\code{\link{LabelSplits}()},
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{PolarizeSplits}()},
\code{\link{SplitFrequency}()},
\code{\link{Splits}},
\code{\link{TipLabels}()},
\code{\link{TipsInSplits}()},
\code{\link{match,Splits,Splits-method}},
\code{\link{xor}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{Splits operations}
\concept{tree properties}
