% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_generation.R
\name{ConstrainedNJ}
\alias{ConstrainedNJ}
\title{Constrained neighbour-joining tree}
\usage{
ConstrainedNJ(dataset, constraint, weight = 1L, ratio = TRUE, ambig = "mean")
}
\arguments{
\item{dataset}{A phylogenetic data matrix of class \code{phyDat},
whose names correspond to the labels of any accompanying tree.}

\item{constraint}{An object of class \code{phyDat}; returned trees will be
perfectly compatible with each character in \code{constraint}.
See \href{https://ms609.github.io/TreeSearch/articles/inapplicable.html}{vignette}
for further examples.}

\item{weight}{Numeric specifying degree to up-weight characters in
\code{constraint}.}

\item{ratio}{Settings of \code{ambig} and \code{ratio} to be used when
computing \code{\link[=Hamming]{Hamming()}} distances between sequences.}

\item{ambig}{Settings of \code{ambig} and \code{ratio} to be used when
computing \code{\link[=Hamming]{Hamming()}} distances between sequences.}
}
\value{
\code{ConstrainedNJ()} returns a tree of class \code{phylo}.
}
\description{
Constructs an approximation to a neighbour-joining tree, modified in order
to be consistent with a constraint.  Zero-length branches are collapsed
at random.
}
\examples{
dataset <- MatrixToPhyDat(matrix(
  c(0, 1, 1, 1, 0, 1,
    0, 1, 1, 0, 0, 1), ncol = 2,
  dimnames = list(letters[1:6], NULL)))
constraint <- MatrixToPhyDat(
  c(a = 0, b = 0, c = 0, d = 0, e = 1, f = 1))
plot(ConstrainedNJ(dataset, constraint))
}
\seealso{
Other tree generation functions: 
\code{\link{GenerateTree}},
\code{\link{NJTree}()},
\code{\link{SingleTaxonTree}()},
\code{\link{TreeNumber}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree generation functions}
