% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/te_stats_glm_logit.R
\docType{class}
\name{te_stats_glm_logit-class}
\alias{te_stats_glm_logit-class}
\alias{te_stats_glm_logit_outcome_fitted-class}
\alias{fit_weights_model,te_stats_glm_logit-method}
\alias{fit_outcome_model,te_stats_glm_logit-method}
\alias{predict,te_stats_glm_logit_outcome_fitted-method}
\title{Fit Models using logistic stats::glm}
\usage{
\S4method{fit_weights_model}{te_stats_glm_logit}(object, data, formula, label)

\S4method{fit_outcome_model}{te_stats_glm_logit}(object, data, formula, weights = NULL)

\S4method{predict}{te_stats_glm_logit_outcome_fitted}(
  object,
  newdata,
  predict_times,
  conf_int = TRUE,
  samples = 100,
  type = c("cum_inc", "survival")
)
}
\arguments{
\item{object}{Object to dispatch method on}

\item{data}{\code{data.frame} containing outcomes and covariates as defined in \code{formula}.}

\item{formula}{\code{formula} describing the model.}

\item{label}{A short string describing the model.}

\item{weights}{\code{numeric} vector of weights.}

\item{newdata}{Baseline trial data that characterise the target trial population that marginal cumulative incidences
or survival probabilities are predicted for.  \code{newdata} must have the same columns and formats of variables as in
the fitted marginal structural model specified in \code{\link[=trial_msm]{trial_msm()}} or \code{\link[=initiators]{initiators()}}. If \code{newdata} contains rows with
\code{followup_time > 0} these will be removed.}

\item{predict_times}{Specify the follow-up visits/times where the marginal cumulative incidences or survival
probabilities are predicted.}

\item{conf_int}{Construct the point-wise 95-percent confidence intervals of cumulative incidences for the target
trial population under treatment and non-treatment and their differences by simulating the parameters in the
marginal structural model from a multivariate normal distribution with the mean equal to the marginal structural
model parameter estimates and the variance equal to the estimated robust covariance matrix.}

\item{samples}{Number of samples used to construct the simulation-based confidence intervals.}

\item{type}{Specify cumulative incidences or survival probabilities to be predicted. Either cumulative incidence
(\code{"cum_inc"}) or survival probability (\code{"survival"}).}
}
\description{
The classes and (internal) methods defined for using \link[stats:glm]{stats::glm} to fit the logistic regression models.
}
\section{Functions}{
\itemize{
\item \code{fit_weights_model(te_stats_glm_logit)}: Fit the weight models object via \link{calculate_weights} on \code{trial_sequence}

\item \code{fit_outcome_model(te_stats_glm_logit)}: Fit the outcome model object via \link{fit_msm} on \code{trial_sequence}

\item \code{predict(te_stats_glm_logit_outcome_fitted)}: Predict from the fitted model object via \link{predict} on \code{trial_sequence}

}}
\seealso{
Other model_fitter_classes: 
\code{\link{te_parsnip_model-class}}
}
\concept{model_fitter_classes}
\keyword{internal}
