% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfqModify.R
\name{lfqModify}
\alias{lfqModify}
\title{Modify lfq data for further analysis}
\usage{
lfqModify(lfq, par = NULL, plus_group = FALSE)
}
\arguments{
\item{lfq}{lfq object with dates, midLengths, and catch}

\item{par}{growth parameter as resulting from e.g. \code{\link{ELEFAN}}}

\item{plus_group}{logical; should a plus group be created? If yes you will be
asked to insert the length for the plus group in the console (default: FALSE).
Instead of inserting the length of the plus group via the console, the value
can be incorporated in a vector, e.g. plus_group = c(TRUE, 30).}
}
\value{
lfq object with rearranged catch matrix (yearly sums) and growth parameters
   if provided.
}
\description{
Rearrange catch matrix in length frequency data (lfq class) to
   have one column per year. This is required for e.g. \code{\link{catchCurve}}.
   Add plus group to catch matrix.
}
\examples{
data(synLFQ4)
newlfq <- lfqModify(synLFQ4)

}
\keyword{function}
\keyword{length-frequency}
\keyword{lfq}

