% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_pancan_value.R
\name{vis_unicox_tree}
\alias{vis_unicox_tree}
\title{Visualize Single Gene Univariable Cox Result from Toil Data Hub}
\usage{
vis_unicox_tree(
  Gene = "TP53",
  measure = "OS",
  data_type = "mRNA",
  threshold = 0.5,
  values = c("grey", "#E31A1C", "#377DB8")
)
}
\arguments{
\item{Gene}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{measure}{a survival measure, e.g. "OS".}

\item{data_type}{choose gene profile type, including "mRNA","transcript","methylation","miRNA","protein","cnv_gistic2"}

\item{threshold}{a expression cutoff, \code{0.5} for median.}

\item{values}{the color to fill tumor or normal}
}
\value{
a \code{ggplot} object
}
\description{
Visualize Single Gene Univariable Cox Result from Toil Data Hub
}
\examples{
\dontrun{
p <- vis_unicox_tree(Gene = "TP53")
}
}
