% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{EVPool}
\alias{EVPool}
\title{Extreme value plot for pooling groups}
\usage{
EVPool(
  x,
  AMAX = NULL,
  gauged = FALSE,
  dist = "GenLog",
  QMED = NULL,
  Title = "Pooled growth curve",
  UrbAdj = FALSE,
  CDs
)
}
\arguments{
\item{x}{pooling group derived from the Pool() function}

\item{AMAX}{the AMAX sample to be plotted in the case of gauged. If NULL, & gauged equals TRUE, the AMAX from the first site in the pooling group is used}

\item{gauged}{logical argument with a default of FALSE. If FALSE, the plot is the ungauged pooled curve accompanied by the single site curves of the group members. If TRUE, the plot is the gauged curve and single site curve with the observed points added}

\item{dist}{a choice of distribution. Choices are "GEV" or "GenLog". The default is "GenLog"}

\item{QMED}{a chosen QMED to convert the curve from a growth curve to the frequency curve}

\item{Title}{a character string. The user chosen plot title. The default is "Pooled growth curve"}

\item{UrbAdj}{a logical argument with a default of FALSE. If TRUE and urban adjustment is applied to the pooled growth curve}

\item{CDs}{catchment descriptors derived from either GetCDs or ImportCDs. Only necessary if UrbAdj is TRUE}
}
\value{
An extreme value plot for gauged or ungauged pooling groups
}
\description{
Plots the extreme value frequency curve or growth curve for gauged or ungauged pooled groups
}
\examples{
#Get some CDs, form an ungauged pooling group and apply EVPlot.
CDs.96001 <- GetCDs(96001)
Pool.96001 <- Pool(CDs.96001, exclude = 96001)
EVPool(Pool.96001)
#Do the same for the gauged case, change the title, and convert with a QMED of 105.5.
PoolG.96001 <- Pool(CDs.96001)
EVPool(PoolG.96001, gauged = TRUE, Title = "Gauged frequency curve - Site 96001", QMED = 105.5)
#Pretend we have an extra AMAX for the gauge. Amend the pooling group Lcv and LSkew
#for the site accordingly then apply EVPool with the updated AMAX.
#Firstly, get the AMAX sample
AM.96001 <- GetAM(96001)
#Add an extra AMAX flow of 350m3/s
Append96001 <- append(AM.96001$Flow, 350)
#Amend the Lcv and Lskew in the pooling group
PoolG.96001[1, c(16, 17)] <- c(Lcv(Append96001), LSkew(Append96001))
#Now plot gauged with the updated AMAX
EVPool(PoolG.96001, AMAX = Append96001, gauged = TRUE)
}
\author{
Anthony Hammond
}
