% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscStat.R
\name{DiscStat}
\alias{DiscStat}
\title{Test statistic for dependence in contingency table}
\usage{
DiscStat(freq)
}
\arguments{
\item{freq}{A two-way contingency table whose strength of dependence is to be measured.}
}
\value{
The value of the test statistic \eqn{T_n}.
}
\description{
This function computes the value of the test statistic \eqn{T_n} measuring the strength of
dependence in a contingency table. See Section 3.1 of \insertCite{BKS2020}{USP}
for a definition.
}
\examples{
freq=r2dtable(1,rep(10,5),rep(10,5))[[1]]; DiscStat(freq)

freq=diag(1:5); DiscStat(freq)

freq=r2dtable(1,rep(10,5),rep(10,5))[[1]] + 4*diag(rep(1,5))
DiscStat(freq)
}
\references{
\insertRef{BKS2020}{USP}
}
